/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn.resourcestate;

import eu.dnetlib.enabling.is.sn.SubscriptionRequest;
import java.io.StringReader;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Entity(name="subscriptions")
@Table(name="subscriptions")
public class ResourceStateSubscription {
    private static final int HASH_SEED_2 = 59;
    private static final int HASH_SEED = 47;
    public static final String PREFIX_CREATE = "CREATE";
    public static final String PREFIX_DELETE = "DELETE";
    public static final String PREFIX_UPDATE = "UPDATE";
    public static final String PREFIX_PENDING_CREATE = "PENDING_CREATE";
    public static final String PREFIX_PENDING_DELETE = "PENDING_DELETE";
    public static final String PREFIX_PENDING_UPDATE = "PENDING_UPDATE";
    @Id
    @Column(name="subscriptionid")
    private String subscriptionId;
    @Column(name="prefix")
    private String prefix;
    @Column(name="type")
    private String type;
    @Column(name="resourceid")
    private String resourceId;
    @Column(name="xpath")
    private String xpath;
    @Column(name="subscriber", length=4096)
    private String subscriber;

    public ResourceStateSubscription() {
        this.type = "*";
        this.resourceId = "*";
    }

    public ResourceStateSubscription(SubscriptionRequest request, String prefix, String type, String resourceId, String xpath) {
        this.setSubscriptionId(request.getSubscriptionId());
        this.setSubscriber(request.getSubscriber());
        this.setPrefix(prefix);
        this.setType(type);
        this.setResourceId(resourceId);
        this.setXpath(xpath);
    }

    public int hashCode() {
        return new HashCodeBuilder(47, 59).append((Object)this.subscriptionId).append((Object)this.subscriber.toString()).append((Object)this.prefix).append((Object)this.type).append((Object)this.xpath).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceStateSubscription)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ResourceStateSubscription rhs = (ResourceStateSubscription)obj;
        return new EqualsBuilder().append((Object)this.subscriptionId, (Object)rhs.getSubscriptionId()).append((Object)this.prefix, (Object)rhs.getPrefix()).append((Object)this.resourceId, (Object)rhs.getResourceId()).append((Object)this.xpath, (Object)rhs.getXpath()).isEquals();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type == null || type.isEmpty() ? "*" : type;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public W3CEndpointReference getSubscriberAsEpr() {
        return (W3CEndpointReference)EndpointReference.readFrom((Source)new StreamSource(new StringReader(this.getSubscriber())));
    }

    public void setSubscriber(W3CEndpointReference epr) {
        this.subscriber = epr != null ? epr.toString() : null;
    }

    public void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId == null || resourceId.isEmpty() ? "*" : resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }
}

