/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn.resourcestate;

import com.google.common.collect.Sets;
import eu.dnetlib.enabling.is.sn.AbstractSubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.SubscriptionRegistry;
import eu.dnetlib.enabling.is.sn.SubscriptionRequest;
import eu.dnetlib.enabling.is.sn.TopicExpressionMatchResult;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionDAO;
import eu.dnetlib.enabling.is.sn.resourcestate.SubscriptionRequestFilter;
import eu.dnetlib.enabling.is.sn.rmi.SubscriptionRequestRejectedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.perl.Perl5Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

public class ResourceStateSubscriptionRegistry
extends AbstractSubscriptionRegistry
implements SubscriptionRegistry {
    private static final Log log = LogFactory.getLog(ResourceStateSubscriptionRegistry.class);
    private ResourceStateSubscriptionDAO subscriptionDao;
    @Autowired
    private SubscriptionRequestFilter subscriptionRequestFilter;

    @Override
    @CacheEvict(value={"subscriptions"}, allEntries=true)
    public String registerSubscription(SubscriptionRequest subscription) throws SubscriptionRequestRejectedException {
        TopicExpressionMatchResult prefixMatch = this.matchPrefix(subscription);
        if (prefixMatch == null) {
            return null;
        }
        TopicExpressionMatchResult typeMatch = this.matchType(prefixMatch.getRest());
        if (typeMatch == null) {
            return null;
        }
        TopicExpressionMatchResult idMatch = this.matchId(typeMatch.getRest());
        if (idMatch == null) {
            return null;
        }
        ResourceStateSubscription rss = new ResourceStateSubscription(subscription, prefixMatch.getPrefix(), typeMatch.getPrefix(), idMatch.getPrefix(), idMatch.getRest());
        if (!this.getSubscriptionRequestFilter().accept(rss)) {
            throw new SubscriptionRequestRejectedException(String.format("rejected subscription request, resourceId: '%s', xpath: '%s', from: %s", rss.getResourceId(), rss.getXpath(), rss.getSubscriber()));
        }
        return this.registerSubscription(rss);
    }

    private String registerSubscription(ResourceStateSubscription subscription) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"evict subscriptions cache");
        }
        Collection<ResourceStateSubscription> similar = this.subscriptionDao.listSubscriptions(subscription.getPrefix(), subscription.getType(), subscription.getResourceId());
        for (ResourceStateSubscription r : similar) {
            if (r == null || !this.getAddress(subscription.getSubscriberAsEpr()).equals(this.getAddress(r.getSubscriberAsEpr())) || subscription.getXpath() != r.getXpath() && !subscription.getXpath().equals(r.getXpath()) || subscription.getResourceId() != r.getResourceId() && !subscription.getResourceId().equals(r.getResourceId())) continue;
            return r.getSubscriptionId();
        }
        this.subscriptionDao.addSubscription(subscription);
        return subscription.getSubscriptionId();
    }

    @Override
    @CacheEvict(value={"subscriptions"}, allEntries=true)
    public boolean unsubscribe(String subId) {
        log.info((Object)"evict subscriptions cache");
        return this.subscriptionDao.removeSubscription(subId);
    }

    private Object getAddress(W3CEndpointReference epr) {
        DOMResult dom = new DOMResult();
        epr.writeTo((Result)dom);
        try {
            return XPathFactory.newInstance().newXPath().evaluate("//*[local-name() = 'Address']", dom.getNode());
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("cannot construct xpath expression", e);
        }
    }

    public TopicExpressionMatchResult matchType(String rest) {
        Perl5Util matcher = new Perl5Util();
        if (!matcher.match("/^(\\*|[a-zA-Z_0-9]*)($|/)(.*)$/", rest)) {
            return null;
        }
        return new TopicExpressionMatchResult(matcher.getMatch().group(1), matcher.getMatch().group(3));
    }

    public TopicExpressionMatchResult matchId(String rest) {
        Perl5Util matcher = new Perl5Util();
        if (!matcher.match("/^([^/]*)(.*)/", rest)) {
            return null;
        }
        return new TopicExpressionMatchResult(matcher.getMatch().group(1), matcher.getMatch().group(2));
    }

    @Override
    @Cacheable(value={"subscriptions"}, key="{ #prefix, #type, #resId }")
    public Collection<ResourceStateSubscription> listMatchingSubscriptions(String prefix, String type, String resId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("uncached list subscriptions [prefix: '%s', type: '%s', resourceId: '%s']", prefix, type, resId));
        }
        HashSet<ResourceStateSubscription> merged = new HashSet<ResourceStateSubscription>();
        merged.addAll(this.subscriptionDao.listSubscriptions(prefix, type, resId));
        merged.addAll(this.subscriptionDao.listSubscriptions(prefix, type, "*"));
        merged.addAll(this.subscriptionDao.listSubscriptions(prefix, "*", "*"));
        return merged;
    }

    @Override
    @Cacheable(value={"subscriptions"})
    public Collection<ResourceStateSubscription> listSubscriptions() {
        log.info((Object)"uncached list subscriptions");
        return Sets.newHashSet(this.subscriptionDao.listSubscriptions());
    }

    @Override
    @CacheEvict(value={"subscriptions"}, allEntries=true)
    public boolean removeSubscription(String subscriptionId) {
        return this.subscriptionDao.removeSubscription(subscriptionId);
    }

    @Override
    protected Collection<String> getAcceptedPrefixes() {
        return Arrays.asList("CREATE", "DELETE", "UPDATE");
    }

    public ResourceStateSubscriptionDAO getSubscriptionDao() {
        return this.subscriptionDao;
    }

    @Required
    public void setSubscriptionDao(ResourceStateSubscriptionDAO subscriptionDao) {
        this.subscriptionDao = subscriptionDao;
    }

    public SubscriptionRequestFilter getSubscriptionRequestFilter() {
        return this.subscriptionRequestFilter;
    }

    public void setSubscriptionRequestFilter(SubscriptionRequestFilter subscriptionRequestFilter) {
        this.subscriptionRequestFilter = subscriptionRequestFilter;
    }
}

