/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn.resourcestate;

import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class SubscriptionRequestFilter {
    private static final Log log = LogFactory.getLog(SubscriptionRequestFilter.class);
    private static final String ANY_RESOURCE = "*";
    @Value(value="${services.issn.subscription.filter.active}")
    private boolean active = false;

    public boolean accept(ResourceStateSubscription rss) {
        if (!this.isActive()) {
            return true;
        }
        if (StringUtils.isBlank((String)rss.getXpath()) & StringUtils.equals((String)rss.getResourceId(), (String)ANY_RESOURCE)) {
            log.debug((Object)String.format("rejected subscription request, resourceId: '%s', xpath: '%s', from: %s", rss.getResourceId(), rss.getXpath(), rss.getSubscriber()));
            return false;
        }
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

