/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn.resourcestate.hib;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscription;
import eu.dnetlib.enabling.is.sn.resourcestate.ResourceStateSubscriptionDAO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

public class HibernateResourceStateSubscriptionDAOImpl
implements ResourceStateSubscriptionDAO {
    private static final Log log = LogFactory.getLog(HibernateResourceStateSubscriptionDAOImpl.class);
    private SessionFactory sessionFactory;

    private Collection<ResourceStateSubscription> transformToSubscription(List<Object> inputList) {
        return Collections2.transform(inputList, (Function)new Function<Object, ResourceStateSubscription>(){

            public ResourceStateSubscription apply(Object input) {
                return (ResourceStateSubscription)input;
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ResourceStateSubscription> listSubscriptions(String prefix, String resourceType, String resourceId) {
        ResourceStateSubscription exampleEntity = new ResourceStateSubscription();
        exampleEntity.setPrefix(prefix);
        exampleEntity.setType(resourceType);
        exampleEntity.setResourceId(resourceId);
        return this.transformToSubscription(this.queryByCriteria(exampleEntity));
    }

    @Override
    @Transactional
    public void addSubscription(ResourceStateSubscription subscription) {
        log.debug((Object)"evict cached subscriptions");
        this.getSessionFactory().getCurrentSession().save((Object)subscription);
    }

    @Override
    @Transactional(readOnly=true)
    public ResourceStateSubscription getSubscription(String subscriptionId) {
        return (ResourceStateSubscription)this.getSessionFactory().getCurrentSession().get(ResourceStateSubscription.class, (Serializable)((Object)subscriptionId));
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ResourceStateSubscription> listSubscriptions() {
        return this.getSessionFactory().getCurrentSession().createQuery("from subscriptions").list();
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<ResourceStateSubscription> listSubscriptions(String prefix) {
        ResourceStateSubscription exampleEntity = new ResourceStateSubscription();
        exampleEntity.setPrefix(prefix);
        return this.transformToSubscription(this.queryByCriteria(exampleEntity));
    }

    @Override
    @Transactional
    public boolean removeSubscription(String subscriptionId) {
        if (StringUtils.isBlank((String)subscriptionId)) {
            return false;
        }
        ResourceStateSubscription entity = this.getSubscription(subscriptionId);
        if (entity == null) {
            return false;
        }
        this.getSessionFactory().getCurrentSession().delete((Object)entity);
        return true;
    }

    private List<Object> queryByCriteria(ResourceStateSubscription exampleEntity) {
        Criteria criteria = this.getSessionFactory().getCurrentSession().createCriteria(ResourceStateSubscription.class).add((Criterion)Example.create((Object)exampleEntity));
        return criteria.list();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Required
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

