/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.store;

import com.google.common.collect.Iterators;
import eu.dnetlib.enabling.is.store.rmi.ISStoreException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import eu.dnetlib.xml.database.XMLDatabase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Required;
import org.xmldb.api.base.XMLDBException;

@WebService(targetNamespace="http://services.dnetlib.eu/")
public class ISStoreServiceImpl
extends AbstractBaseService
implements ISStoreService {
    private static final Log log = LogFactory.getLog(ISStoreServiceImpl.class);
    private XMLDatabase xmlDatabase;
    private Endpoint endpoint;
    private ResultSetFactory resultSetFactory;
    @Resource(name="jaxwsEndpointReferenceBuilder")
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private Job contentInitializerJob;

    public void start() {
        super.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    ISStoreServiceImpl.this.contentInitializerJob.execute(null);
                }
                catch (JobExecutionException e) {
                    log.fatal((Object)"failed to initialize xmldb", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.fatal((Object)"failed to initialize xmldb", (Throwable)e);
                }
            }
        }).start();
    }

    public boolean createFileColl(String fileColl) throws ISStoreException {
        try {
            this.xmlDatabase.createCollection(fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
        return true;
    }

    public boolean deleteFileColl(String fileColl) throws ISStoreException {
        try {
            this.xmlDatabase.removeCollection(fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
        return true;
    }

    public boolean deleteXML(String fileName, String fileColl) throws ISStoreException {
        try {
            return this.xmlDatabase.remove(fileName, fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
    }

    public boolean executeXUpdate(String query) throws ISStoreException {
        this.getXMLbyQuery(query);
        return true;
    }

    public List<String> getFileColls() throws ISStoreException {
        try {
            return this.xmlDatabase.listChildCollections(this.xmlDatabase.getRootCollection());
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
    }

    public List<String> getFileNames(String fileColl) throws ISStoreException {
        try {
            return this.xmlDatabase.list(fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
    }

    public String getXML(String fileName, String fileColl) throws ISStoreException {
        try {
            return this.xmlDatabase.read(fileName, fileColl);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
    }

    public String getXMLbyQuery(String query) throws ISStoreException {
        log.debug((Object)query);
        try {
            Iterator res = this.xmlDatabase.xquery(query);
            if (res == null) {
                return null;
            }
            if (!res.hasNext()) {
                return null;
            }
            return (String)res.next();
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
    }

    public boolean insertXML(String fileName, String fileColl, String file) throws ISStoreException {
        try {
            this.xmlDatabase.create(fileName, fileColl, file);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
        return true;
    }

    public List<String> quickSearchXML(String query) throws ISStoreException {
        log.debug((Object)query);
        try {
            Iterator res = this.xmlDatabase.xquery(query);
            if (res == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> ans = new ArrayList<String>();
            Iterators.addAll(ans, (Iterator)res);
            return ans;
        }
        catch (XMLDBException e) {
            log.fatal((Object)"searching", (Throwable)e);
            throw new ISStoreException((Throwable)e);
        }
    }

    public boolean reindex() {
        return true;
    }

    public boolean sync() {
        log.info((Object)("TEST: " + this.endpoint));
        return true;
    }

    public boolean updateXML(String fileName, String fileColl, String file) throws ISStoreException {
        try {
            this.xmlDatabase.update(fileName, fileColl, file);
        }
        catch (XMLDBException e) {
            throw new ISStoreException((Throwable)e);
        }
        return true;
    }

    public String backup() throws ISStoreException {
        try {
            return this.xmlDatabase.backup();
        }
        catch (Exception e) {
            throw new ISStoreException((Throwable)e);
        }
    }

    public XMLDatabase getXmlDatabase() {
        return this.xmlDatabase;
    }

    public void setXmlDatabase(XMLDatabase xmlDatabase) {
        this.xmlDatabase = xmlDatabase;
    }

    public boolean isRunning() {
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    protected void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    @Required
    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public Job getContentInitializerJob() {
        return this.contentInitializerJob;
    }

    public void setContentInitializerJob(Job contentInitializerJob) {
        this.contentInitializerJob = contentInitializerJob;
    }
}

