/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.store;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.store.AbstractContentInitializer;
import eu.dnetlib.enabling.tools.ResourceLoaderHelper;
import eu.dnetlib.miscutils.coupling.StaticCondition;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class TestContentInitializerJob
extends AbstractContentInitializer
implements Job {
    private static final double MILLIS = 1000.0;
    static final Log log = LogFactory.getLog(TestContentInitializerJob.class);
    private static boolean initialized = false;
    private String resources;
    private String schemas;
    private ResourceLoaderHelper resourceLoader;
    private StaticCondition snDisable;

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        this.initialize();
        TestContentInitializerJob.setInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws JobExecutionException {
        log.info((Object)"Initializing store with some profiles and collections for test and development ...");
        if (!this.getBulkImporter().isEnabled()) {
            log.info((Object)"skipping store initialization because the database already exists");
            return;
        }
        log.info((Object)("loading resources: " + this.getResources()));
        try {
            String type = "schema/profile";
            String name = "none";
            try {
                long start = System.currentTimeMillis();
                type = "schema";
                for (Resource res : this.resourceLoader.getResourcePatternResolver().getResources(this.schemas)) {
                    name = res.getURL().toString();
                    this.registerSchema(res.getURL());
                }
                try {
                    this.snDisable.setCondition(true);
                    type = "profile";
                    for (Resource res : this.resourceLoader.getResourcePatternResolver().getResources(this.resources)) {
                        name = res.getURL().toString();
                        this.registerProfile(res.getURL());
                    }
                }
                finally {
                    this.snDisable.setCondition(false);
                }
                log.info((Object)("bulk registration finished in: " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s"));
            }
            catch (ISRegistryException e) {
                log.fatal((Object)("cannot register " + type + ": " + name), (Throwable)e);
                throw new JobExecutionException("registry exception", (Throwable)e);
            }
            catch (IOException e) {
                throw new JobExecutionException("io exception", (Throwable)e);
            }
            catch (XPathExpressionException e) {
                throw new JobExecutionException("xpath exception", (Throwable)e);
            }
            catch (SAXException e) {
                throw new JobExecutionException("sax exception", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new JobExecutionException("parser exception", (Throwable)e);
            }
        }
        finally {
            log.info((Object)"INITIALIZED");
            TestContentInitializerJob.setInitialized(true);
        }
    }

    public static void setInitialized(boolean initialized) {
        TestContentInitializerJob.initialized = initialized;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public void setResources(String resources) {
        this.resources = resources;
    }

    public String getResources() {
        return this.resources;
    }

    @Required
    public ResourceLoaderHelper getResourceLoader() {
        return this.resourceLoader;
    }

    @Required
    public void setResourceLoader(ResourceLoaderHelper resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Required
    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public void setSnDisable(StaticCondition snDisable) {
        this.snDisable = snDisable;
    }

    public StaticCondition getSnDisable() {
        return this.snDisable;
    }
}

