/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.is.sn.rmi.ISSNService;
import eu.dnetlib.enabling.is.store.rmi.ISStoreException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ResourceType {
    public static final String RESOURCE_TYPES = "DRIVERResourceTypes";
    private String resourceType;
    private String resourceSchema;
    private File fileSchema;

    public ResourceType(String resourceType, ISStoreService store, String basedir) throws ISStoreException {
        this(resourceType, store.getXML(resourceType, RESOURCE_TYPES), basedir);
    }

    public ResourceType(String resourceType, String resourceSchema, String basedir) throws ISStoreException {
        this.resourceType = resourceType;
        this.resourceSchema = resourceSchema;
        if (basedir != null) {
            this.fileSchema = this.saveSchemaAsFile(basedir);
        }
    }

    public void store(ISStoreService store) throws ISStoreException {
        store.insertXML(this.resourceType, RESOURCE_TYPES, this.resourceSchema);
    }

    public void update(ISStoreService store) throws ISStoreException {
        store.updateXML(this.resourceType, RESOURCE_TYPES, this.resourceSchema);
    }

    private File saveSchemaAsFile(String basedir) throws ISStoreException {
        this.fileSchema = new File(basedir + "/" + this.resourceType);
        if (!this.fileSchema.exists()) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.fileSchema));
                out.write(this.resourceSchema);
                out.close();
            }
            catch (IOException e) {
                throw new ISStoreException("Error saving file", (Throwable)e);
            }
        }
        return this.fileSchema;
    }

    public void deleteAndNotify(ISStoreService store, ISSNService issn) throws ISStoreException {
        this.fileSchema.delete();
        store.deleteXML(this.resourceType, RESOURCE_TYPES);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceSchema() {
        return this.resourceSchema;
    }

    public void setResourceSchema(String resourceSchema) {
        this.resourceSchema = resourceSchema;
    }

    public File getFileSchema() {
        return this.fileSchema;
    }

    public void setFileSchema(File fileSchema) {
        this.fileSchema = fileSchema;
    }
}

