/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry;

import eu.dnetlib.enabling.is.registry.NoSuchPendingCategoryException;
import eu.dnetlib.enabling.is.registry.ResourceKindResolver;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ResourceKindResolverChain
implements ResourceKindResolver {
    private static final Log log = LogFactory.getLog(ResourceKindResolverChain.class);
    private List<ResourceKindResolver> resolvers;

    @Override
    public String getNormalKindForType(String resourceType) throws XPathExpressionException {
        for (ResourceKindResolver resolver : this.resolvers) {
            String res = resolver.getNormalKindForType(resourceType);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public String getPendingKindForType(String resourceType) throws XPathExpressionException {
        for (ResourceKindResolver resolver : this.resolvers) {
            try {
                String res = resolver.getPendingKindForType(resourceType);
                if (res == null) continue;
                return res;
            }
            catch (NoSuchPendingCategoryException e) {
                log.debug((Object)"resolver didn't find pending category", (Throwable)e);
            }
        }
        log.debug((Object)"cannot find pending category because no resolver found a pending category");
        throw new NoSuchPendingCategoryException("no pending category for " + resourceType);
    }

    public List<ResourceKindResolver> getResolvers() {
        return this.resolvers;
    }

    @Required
    public void setResolvers(List<ResourceKindResolver> resolvers) {
        this.resolvers = resolvers;
    }
}

