/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.sn;

import eu.dnetlib.common.rmi.BaseService;
import eu.dnetlib.enabling.is.sn.NotificationInvocationLogger;
import eu.dnetlib.enabling.is.sn.NotificationInvoker;
import eu.dnetlib.enabling.is.sn.NotificationMessage;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class NotificationInvokerImpl
implements NotificationInvoker {
    private static final Log log = LogFactory.getLog(NotificationInvokerImpl.class);
    private NotificationInvocationLogger invocationLogger;

    @Override
    public void send(W3CEndpointReference destination, NotificationMessage message, int timeout) {
        BaseService service = (BaseService)destination.getPort(BaseService.class, new WebServiceFeature[0]);
        log.info((Object)("phisically sending notification: " + message.getTopic()));
        NotificationInvocationLogger.Entry logEntry = this.invocationLogger.startLogging(destination, message);
        logEntry.ongoing();
        try {
            service.notify(message.getSubscriptionId(), message.getTopic(), message.getResourceId(), message.getBody());
            logEntry.success();
        }
        catch (Throwable e) {
            log.debug((Object)"notification error", e);
            logEntry.failure(e);
        }
    }

    public NotificationInvocationLogger getInvocationLogger() {
        return this.invocationLogger;
    }

    @Required
    public void setInvocationLogger(NotificationInvocationLogger invocationLogger) {
        this.invocationLogger = invocationLogger;
    }
}

