/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.registry;

import eu.dnetlib.enabling.is.registry.PendingResourceManager;
import eu.dnetlib.enabling.is.registry.ResourceKindResolver;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.is.registry.schema.OpaqueResourceValidator;
import eu.dnetlib.enabling.is.registry.schema.ValidationException;
import eu.dnetlib.enabling.is.registry.validation.ProfileValidationStrategy;
import eu.dnetlib.enabling.is.registry.validation.RegistrationPhase;
import eu.dnetlib.enabling.is.store.rmi.ISStoreException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.tools.CompatResourceIdentifierResolverImpl;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.ResourceIdentifierComposer;
import eu.dnetlib.enabling.tools.ResourceIdentifierResolver;
import eu.dnetlib.enabling.tools.XQueryUtils;
import java.util.Date;
import javax.annotation.Resource;
import javax.xml.xpath.XPathExpressionException;
import org.springframework.beans.factory.annotation.Required;

public class IdPreservingPendingResourceManagerImpl
implements PendingResourceManager,
ResourceKindResolver {
    private ISRegistryService isRegistry;
    private ISStoreService isStore;
    private ResourceKindResolver resourceKindResolver;
    private OpaqueResourceValidator resourceValidator;
    private XQueryUtils xqueryUtils;
    @Resource
    private ResourceIdentifierResolver resIdResolver = new CompatResourceIdentifierResolverImpl();
    @Resource
    private ResourceIdentifierComposer resIdComposer = new CompatResourceIdentifierResolverImpl();
    @Resource
    private ProfileValidationStrategy profileValidationStrategy;

    @Override
    public void setPending(OpaqueResource resource, boolean local) {
        try {
            resource.setResourceKind(this.getPendingKindForType(resource.getResourceType()));
            if (!local) {
                this.isRegistry.deleteProfile(resource.getResourceId());
                this.registerProfile(resource);
            }
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setPending(OpaqueResource resource) {
        this.setPending(resource, false);
    }

    @Override
    public void setValid(OpaqueResource resource) {
        try {
            if (resource.getResourceKind() != null && resource.getResourceKind().equals(this.getNormalKindForType(resource.getResourceType()))) {
                throw new IllegalArgumentException("trying to validate an already valid resource");
            }
            this.profileValidationStrategy.accept(resource, RegistrationPhase.Validate);
            resource.setResourceKind(this.getNormalKindForType(resource.getResourceType()));
            this.isRegistry.deleteProfile(resource.getResourceId());
            this.registerProfile(resource);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException(e);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    public String registerProfile(OpaqueResource resource) throws ISRegistryException {
        try {
            String oldId = resource.getResourceId();
            String fileName = this.resIdResolver.getFileName(oldId);
            String newColl = this.xqueryUtils.getCollectionPath(resource);
            String newId = this.resIdComposer.createResourceId(fileName, newColl);
            resource.setResourceId(newId);
            resource.setModificationDate(new Date());
            this.resourceValidator.validate(resource);
            this.isStore.insertXML(fileName, this.xqueryUtils.getRootCollection() + newColl, resource.asString());
            return resource.getResourceId();
        }
        catch (ISStoreException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ISRegistryException("profile is not conforming to the schema: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getNormalKindForType(String resourceType) throws XPathExpressionException {
        return this.resourceKindResolver.getNormalKindForType(resourceType);
    }

    @Override
    public String getPendingKindForType(String resourceType) throws XPathExpressionException {
        return this.resourceKindResolver.getPendingKindForType(resourceType);
    }

    public ResourceKindResolver getResourceKindResolver() {
        return this.resourceKindResolver;
    }

    @Required
    public void setResourceKindResolver(ResourceKindResolver resourceKindResolver) {
        this.resourceKindResolver = resourceKindResolver;
    }

    @Required
    public void setXqueryUtils(XQueryUtils xqueryUtils) {
        this.xqueryUtils = xqueryUtils;
    }

    public OpaqueResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    @Required
    public void setResourceValidator(OpaqueResourceValidator resourceValidator) {
        this.resourceValidator = resourceValidator;
    }

    public ISRegistryService getIsRegistry() {
        return this.isRegistry;
    }

    @Required
    public void setIsRegistry(ISRegistryService isRegistry) {
        this.isRegistry = isRegistry;
    }

    public ISStoreService getIsStore() {
        return this.isStore;
    }

    @Required
    public void setIsStore(ISStoreService isStore) {
        this.isStore = isStore;
    }
}

