/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.maps;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentSizedMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 5864196164431521782L;
    public int DEFAULT_SIZE = 4;
    private int queueSize;
    private Queue<K> queue = new ConcurrentLinkedQueue<K>();

    public ConcurrentSizedMap() {
        this.queueSize = this.DEFAULT_SIZE;
    }

    @Override
    public V put(K key, V value) {
        this.queue.add(key);
        if (this.queue.size() > this.queueSize) {
            super.remove(this.queue.poll());
        }
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.queue.remove(key);
        return super.remove(key);
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }
}

