/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.collections;

import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.collections.TypeFilteredCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FilteredCollection<T>
implements Iterable<T> {
    private final transient Iterable<T> coll;
    transient UnaryFunction<Boolean, T> filter;

    public static <X> Iterable<X> filter(Iterable<X> coll, UnaryFunction<Boolean, X> filter) {
        return new FilteredCollection<X>(coll, filter);
    }

    public static <X> Iterable<X> filter(X[] coll, UnaryFunction<Boolean, X> filter) {
        return new FilteredCollection<X>(coll, filter);
    }

    public static <X> List<X> listFilter(Iterable<X> coll, UnaryFunction<Boolean, X> filter) {
        return Lists.newArrayList(FilteredCollection.filter(coll, filter));
    }

    public static <X> List<X> listFilter(X[] coll, UnaryFunction<Boolean, X> filter) {
        return Lists.newArrayList(FilteredCollection.filter(coll, filter));
    }

    public FilteredCollection(Collection<T> coll, UnaryFunction<Boolean, T> filter) {
        this.coll = coll;
        this.filter = filter;
    }

    public FilteredCollection(Iterable<T> coll, UnaryFunction<Boolean, T> filter) {
        this.coll = coll;
        this.filter = filter;
    }

    public FilteredCollection(T[] coll, UnaryFunction<Boolean, T> filter) {
        this.coll = Lists.newArrayList((Object[])coll);
        this.filter = filter;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator();
    }

    public static void main(String[] args) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("ciao");
        list.add(2);
        list.add("bubu");
        TypeFilteredCollection filtered = new TypeFilteredCollection(list, String.class);
        for (String el : filtered) {
            System.out.println("element: " + el);
        }
        System.out.println("ok");
    }

    class FilterIterator
    implements Iterator<T> {
        private final transient Iterator<T> iter;
        transient T nextElement;

        public FilterIterator() {
            this.iter = FilteredCollection.this.coll.iterator();
            this.scanNext();
        }

        private void scanNext() {
            while (this.iter.hasNext()) {
                Object element = this.iter.next();
                if (!FilteredCollection.this.filter.evaluate(element).booleanValue()) continue;
                this.nextElement = element;
                return;
            }
            this.nextElement = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            Object res = this.nextElement;
            this.scanNext();
            return res;
        }

        @Override
        public void remove() {
        }
    }
}

