/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.collections;

import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MappedCollection<T, K>
implements Iterable<T> {
    private final transient Iterable<K> coll;
    private final transient UnaryFunction<T, K> mapper;

    public static <X, Y> Iterable<X> map(Iterable<Y> coll, UnaryFunction<X, Y> mapper) {
        return new MappedCollection<X, Y>(coll, mapper);
    }

    public static <X, Y> Iterable<X> map(Y[] coll, UnaryFunction<X, Y> mapper) {
        return new MappedCollection<X, Y>(coll, mapper);
    }

    public static <X, Y> List<X> listMap(Iterable<Y> coll, UnaryFunction<X, Y> mapper) {
        return Lists.newArrayList(MappedCollection.map(coll, mapper));
    }

    public static <X, Y> List<X> listMap(Y[] coll, UnaryFunction<X, Y> mapper) {
        return Lists.newArrayList(MappedCollection.map(coll, mapper));
    }

    public MappedCollection(Collection<K> coll, UnaryFunction<T, K> mapper) {
        this.coll = coll;
        this.mapper = mapper;
    }

    public MappedCollection(Iterable<K> coll, UnaryFunction<T, K> mapper) {
        this.coll = coll;
        this.mapper = mapper;
    }

    public MappedCollection(K[] coll, UnaryFunction<T, K> mapper) {
        this.coll = Lists.newArrayList((Object[])coll);
        this.mapper = mapper;
    }

    @Override
    public Iterator<T> iterator() {
        return new MappedIterator();
    }

    class MappedIterator
    implements Iterator<T> {
        private final transient Iterator<K> iter;

        public MappedIterator() {
            this.iter = MappedCollection.this.coll.iterator();
        }

        @Override
        public T next() {
            return MappedCollection.this.mapper.evaluate(this.iter.next());
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

