/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.dom4j;

import eu.dnetlib.miscutils.collections.TypeFilteredCollection;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XPathHelper {
    public static Iterable<Element> selectElements(Node base, String xpath) {
        List children = base.selectNodes(xpath);
        return new TypeFilteredCollection(children, Element.class);
    }

    public static Iterable<Element> selectElements(String base, String xpath) {
        try {
            Document document = new SAXReader().read((Reader)new StringReader(base));
            return XPathHelper.selectElements((Node)document, xpath);
        }
        catch (DocumentException e) {
            return new ArrayList<Element>();
        }
    }

    public static Element selectElement(Node base, String xpath) {
        Iterator<Element> iterator = XPathHelper.selectElements(base, xpath).iterator();
        if (iterator.hasNext()) {
            Element el = iterator.next();
            return el;
        }
        return null;
    }

    public static Element selectElement(String base, String xpath) {
        Iterator<Element> iterator = XPathHelper.selectElements(base, xpath).iterator();
        if (iterator.hasNext()) {
            Element el = iterator.next();
            return el;
        }
        return null;
    }
}

