/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import eu.dnetlib.data.mdstore.modular.RecordParser;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class SimpleRecordParser
implements RecordParser {
    static final Log log = LogFactory.getLog(SimpleRecordParser.class);
    private long ts;

    @Override
    public Map<String, String> parseRecord(String record) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("timestamp", String.valueOf(this.getTimestamp()));
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            InputSource doc = new InputSource(new StringReader(record));
            props.put("id", xpath.evaluate("//*[local-name()='objIdentifier']", doc));
            props.put("originalId", xpath.evaluate("//*[local-name()='efgEntity']/*/*[local-name()='identifier']", doc));
        }
        catch (Exception e) {
            log.warn((Object)"got exception while parsing document", (Throwable)e);
            log.warn((Object)"record is:");
            log.warn((Object)record);
            log.warn((Object)"------------");
        }
        return props;
    }

    @Override
    public void setTimestamp(long ts) {
        this.ts = ts;
        log.debug((Object)("RecordParser date set to " + ts));
    }

    @Override
    public long getTimestamp() {
        return this.ts;
    }
}

