/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDFormatDescription;
import eu.dnetlib.data.mdstore.modular.RecordParser;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.IndexFieldRecordParser;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.IndexFieldRecordParserException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class MongoBulkWritesManager {
    private static final Log log = LogFactory.getLog(MongoBulkWritesManager.class);
    private final boolean discardRecords;
    private final boolean indexRecords;
    private final IndexFieldRecordParser indexFieldRecordParser = new IndexFieldRecordParser();
    private final List<MDFormatDescription> mdref;
    private RecordParser recordParser;
    private MongoCollection<DBObject> validCollection;
    private List<WriteModel<DBObject>> validBulkOperationList;
    private BulkWriteOptions writeOptions;
    private MongoCollection<DBObject> discardedCollection;
    private List<WriteModel<DBObject>> discardedBulkOperationList;
    private int bulkSize;

    public MongoBulkWritesManager(MongoCollection<DBObject> collection, MongoCollection<DBObject> discardedCollection, List<MDFormatDescription> mdref, int bulkSize, RecordParser parser, boolean discardRecords) {
        this.validCollection = collection.withWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.validBulkOperationList = Lists.newArrayList();
        this.discardedCollection = discardedCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.discardedBulkOperationList = Lists.newArrayList();
        this.bulkSize = bulkSize;
        this.recordParser = parser;
        this.discardRecords = discardRecords;
        this.mdref = mdref;
        this.indexRecords = this.mdref != null && !this.mdref.isEmpty();
        this.writeOptions = new BulkWriteOptions().ordered(false);
    }

    public void insert(String record) throws MDStoreServiceException {
        Map recordProperties;
        block10: {
            recordProperties = null;
            try {
                recordProperties = this.recordParser.parseRecord(record);
            }
            catch (Throwable e) {
                if (!this.discardRecords) break block10;
                log.debug((Object)("unhandled exception: " + e.getMessage()));
                this.discardRecord(record);
            }
        }
        Map<String, List<String>> indexRecordField = null;
        try {
            if (this.indexRecords) {
                indexRecordField = this.indexFieldRecordParser.parseRecord(record, this.mdref);
            }
        }
        catch (IndexFieldRecordParserException e) {
            throw new MDStoreServiceException("Are you using the correct type of store / index definition for the records in " + this.validCollection.getNamespace() + " ?", (Throwable)e);
        }
        log.debug((Object)("found props: " + recordProperties));
        if (recordProperties.containsKey("id")) {
            DBObject obj = this.buildDBObject(record, recordProperties, indexRecordField);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving object" + obj));
            }
            this.validBulkOperationList.add((WriteModel<DBObject>)new ReplaceOneModel((Bson)new BasicDBObject("id", obj.get("id")), (Object)obj, new UpdateOptions().upsert(true)));
            if (this.validBulkOperationList.size() % this.bulkSize == 0 && !this.validBulkOperationList.isEmpty()) {
                this.validCollection.bulkWrite(this.validBulkOperationList, this.writeOptions);
                this.validBulkOperationList.clear();
            }
        } else if (this.discardRecords) {
            log.debug((Object)"parsed record seems invalid");
            this.discardRecord(record);
        }
    }

    private void discardRecord(String record) {
        this.discardedBulkOperationList.add((WriteModel<DBObject>)new InsertOneModel((Object)new BasicDBObject("body", (Object)record)));
        if (this.discardedBulkOperationList.size() % this.bulkSize == 0 && !this.discardedBulkOperationList.isEmpty()) {
            this.discardedCollection.bulkWrite(this.discardedBulkOperationList, this.writeOptions);
            this.discardedBulkOperationList.clear();
        }
    }

    public void flushBulks() {
        if (!this.validBulkOperationList.isEmpty()) {
            this.validCollection = this.getCollectionWithWriteConcern(this.validCollection, WriteConcern.JOURNALED);
            this.validCollection.bulkWrite(this.validBulkOperationList, this.writeOptions);
        }
        if (!this.discardedBulkOperationList.isEmpty()) {
            this.discardedCollection = this.getCollectionWithWriteConcern(this.discardedCollection, WriteConcern.JOURNALED);
            this.discardedCollection.bulkWrite(this.discardedBulkOperationList, this.writeOptions);
        }
        this.validCollection = this.getCollectionWithWriteConcern(this.validCollection, WriteConcern.ACKNOWLEDGED);
        this.discardedCollection = this.getCollectionWithWriteConcern(this.discardedCollection, WriteConcern.ACKNOWLEDGED);
    }

    protected DBObject buildDBObject(String record, Map<String, String> recordProperties, Map<String, List<String>> indexFieldProperties) {
        BasicDBObject obj = new BasicDBObject();
        obj.put("id", (Object)recordProperties.get("id"));
        obj.put("originalId", (Object)recordProperties.get("originalId"));
        obj.put("body", (Object)record);
        obj.put("timestamp", (Object)Long.valueOf(recordProperties.get("timestamp")));
        if (indexFieldProperties != null) {
            obj.putAll(Maps.filterKeys(indexFieldProperties, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String s) {
                    return !s.equalsIgnoreCase("id") && !s.equalsIgnoreCase("originalId") && !s.equalsIgnoreCase("body") && !s.equalsIgnoreCase("timestamp");
                }
            }));
        }
        return obj;
    }

    private MongoCollection<DBObject> getCollectionWithWriteConcern(MongoCollection<DBObject> collection, WriteConcern writeConcern) {
        return collection.withWriteConcern(writeConcern);
    }
}

