/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.maps.ConcurrentSizedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(MongoResultSetListener.class);
    private ConcurrentSizedMap<Integer, String> lastKeys = new ConcurrentSizedMap();
    private Bson sortByIdAsc = Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"id"})});
    private Function<DBObject, String> serializer;
    private MongoCollection<DBObject> collection;
    private Bson query;

    public MongoResultSetListener(MongoCollection<DBObject> collection, Long from, Long until, Pattern filter, Function<DBObject, String> serializer) {
        this.collection = collection;
        this.serializer = serializer;
        this.query = this.query(from, until, filter);
        log.debug((Object)("Query on mongo: " + this.query.toBsonDocument(BsonDocument.class, MongoClient.getDefaultCodecRegistry())));
    }

    public List<String> getResult(int fromPosition, int toPosition) {
        ArrayList<DBObject> page = null;
        String lastKey = (String)this.lastKeys.get((Object)fromPosition);
        page = lastKey != null ? this.continueFrom(lastKey, toPosition - fromPosition + 1) : this.fetchNew(fromPosition - 1, toPosition - fromPosition + 1);
        if (!page.isEmpty()) {
            DBObject last = page.get(page.size() - 1);
            this.lastKeys.put((Object)(toPosition + 1), (Object)((String)last.get("id")));
        }
        if (log.isDebugEnabled()) {
            log.info((Object)String.format("got %s records from %s to %s", page.size(), fromPosition, toPosition));
        }
        return Lists.newArrayList((Iterable)Iterables.transform(page, this.serializer));
    }

    private ArrayList<DBObject> fetchNew(int from, int size) {
        FindIterable it = this.collection.find(this.query).batchSize(size);
        return Lists.newArrayList((Iterable)it.sort(this.sortByIdAsc).skip(from).limit(size));
    }

    private ArrayList<DBObject> continueFrom(String lastKey, int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to continue from previous key: " + lastKey));
        }
        Bson q = Filters.and((Bson[])new Bson[]{this.query, Filters.gt((String)"id", (Object)lastKey)});
        FindIterable it = this.collection.find(q).batchSize(size).sort(this.sortByIdAsc).limit(size);
        return Lists.newArrayList((Iterable)it);
    }

    private Bson query(Long from, Long until, Pattern pattern) {
        Bson regexFilter;
        Bson dateFilter = this.dateQuery(from, until);
        if (dateFilter != null & (regexFilter = this.regexQuery(pattern)) != null) {
            return Filters.and((Bson[])new Bson[]{dateFilter, regexFilter});
        }
        if (dateFilter != null) {
            return dateFilter;
        }
        if (regexFilter != null) {
            return regexFilter;
        }
        return new BasicDBObject();
    }

    private Bson dateQuery(Long from, Long until) {
        if (from != null & until != null) {
            return Filters.and((Bson[])new Bson[]{Filters.gt((String)"timestamp", (Object)from), Filters.lt((String)"timestamp", (Object)until)});
        }
        if (from != null) {
            return Filters.gt((String)"timestamp", (Object)from);
        }
        if (until != null) {
            return Filters.lt((String)"timestamp", (Object)until);
        }
        return null;
    }

    private Bson regexQuery(Pattern pattern) {
        if (pattern != null) {
            return Filters.regex((String)"body", (Pattern)pattern);
        }
        return null;
    }

    public int getSize() {
        return (int)this.collection.count(this.query);
    }

    public void setResultSet(ResultSet resultSet) {
        resultSet.close();
    }
}

