/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb.utils;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.mdstore.modular.MDFormatDescription;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.IndexFieldRecordParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexFieldRecordParser {
    private static final Log log = LogFactory.getLog(IndexFieldRecordParser.class);

    private static List<String> getTextValue(AutoPilot ap, VTDNav vn, String xpath) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        ap.selectXPath(xpath);
        while (ap.evalXPath() != -1) {
            int t = vn.getText();
            if (t <= -1) continue;
            results.add(vn.toNormalizedString(t));
        }
        return results;
    }

    public Map<String, List<String>> parseRecord(String record, List<MDFormatDescription> mdformats) throws IndexFieldRecordParserException {
        if (mdformats == null || mdformats.size() == 0) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        try {
            VTDGen vg = new VTDGen();
            vg.setDoc(record.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            for (MDFormatDescription description : mdformats) {
                List<String> xpathResult = IndexFieldRecordParser.getTextValue(ap, vn, description.getXpath());
                result.put(description.getName(), xpathResult);
            }
            return result;
        }
        catch (Throwable e) {
            throw new IndexFieldRecordParserException("Cannot index record", e);
        }
    }
}

