/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb.utils;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDStoreDescription;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.enabling.tools.AbstractSchedulable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class EnsureIndexJob
extends AbstractSchedulable {
    private static final Log log = LogFactory.getLog(EnsureIndexJob.class);
    private MDStoreDao dao;

    protected void doExecute() {
        log.info((Object)"performing mdstore index check");
        try {
            for (MDStoreDescription mdstore : this.getDao().listMDStores()) {
                try {
                    log.info((Object)("ensureindex for mdStoreId:" + mdstore.getId()));
                    ((MongoMDStore)this.getDao().getMDStore(mdstore.getId())).ensureIndices();
                }
                catch (Throwable e) {
                    log.warn((Object)("unable to reindex mdstore: " + mdstore.getId()), e);
                }
            }
        }
        catch (MDStoreServiceException e) {
            log.warn((Object)"unable to reindex mdstore ", (Throwable)e);
        }
        log.info((Object)"mdstore index check completed");
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public MDStoreDao getDao() {
        return this.dao;
    }
}

