/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.inspector;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDStoreDescription;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreManagerInfo;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionManager;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.TryIndentXmlString;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MDStoreInspector
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(MDStoreInspector.class);
    @Resource(name="mongodbMDStoreDao")
    private MDStoreDao dao;
    @Autowired
    private MDStoreTransactionManager transactionManager;
    @Resource
    private MDStoreFeeder feeder;
    @Value(value="${dhp.openaire.mdstore.inspector.url}")
    private String hadoopMdstoreInspectorUrl;

    @RequestMapping(value={"/inspector/mdstores.do"})
    public void mdstores(Model model) throws MDStoreServiceException {
        model.addAttribute("mdstores", (Object)this.dao.listMDStores());
    }

    @RequestMapping(value={"/inspector/mdstore.do"}, method={RequestMethod.GET})
    public String mdstore(Model model, final @RequestParam(value="id") String id, @RequestParam(value="start", required=false) Integer startParam, @RequestParam(value="regex", required=false) String regex) throws MDStoreServiceException {
        if (StringUtils.isNotBlank((CharSequence)this.hadoopMdstoreInspectorUrl) && id.startsWith("md-")) {
            String url = String.format(this.hadoopMdstoreInspectorUrl, id);
            log.info((Object)("Redirect to " + url));
            return "redirect:" + url;
        }
        int pageSize = 10;
        int start = 0;
        if (startParam != null) {
            start = startParam;
        }
        MongoMDStore mdstore = (MongoMDStore)this.dao.getMDStore(id);
        ResultSetListener rs = mdstore.deliver(null, null, regex);
        Function<String, Map<String, String>> function = new Function<String, Map<String, String>>(){
            private SAXReader reader = new SAXReader();

            public Map<String, String> apply(String input) {
                try {
                    Document doc = this.reader.read((Reader)new StringReader(input));
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("docId", doc.valueOf("//*[local-name()='objIdentifier']"));
                    result.put("body", input.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                    result.put("mdId", id);
                    return result;
                }
                catch (DocumentException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        List page = Lists.transform((List)MappedCollection.listMap((Iterable)rs.getResult(1 + start, start + pageSize), (UnaryFunction)new TryIndentXmlString()), (Function)function);
        model.addAttribute("id", (Object)id);
        model.addAttribute("start", (Object)start);
        model.addAttribute("regex", (Object)regex);
        model.addAttribute("nextPage", (Object)(start + pageSize));
        model.addAttribute("prevPage", (Object)Math.max(0, start - pageSize));
        model.addAttribute("size", (Object)rs.getSize());
        model.addAttribute("page", (Object)page);
        return "inspector/mdstore";
    }

    @RequestMapping(value={"/inspector/mdstore.do"}, method={RequestMethod.POST})
    public String bulkReplace(Model model, @RequestParam(value="id") String id, @RequestParam(value="regex") String regex, @RequestParam(value="replace") String replace, @RequestParam(value="checkReplace", required=false) Boolean checkReplace) throws MDStoreServiceException {
        boolean replaceEnable;
        log.debug((Object)("regex: " + regex));
        log.debug((Object)("replace: " + replace));
        MongoMDStore mdstore = (MongoMDStore)this.dao.getMDStore(id);
        boolean bl = replaceEnable = checkReplace != null && checkReplace == true;
        if (replaceEnable) {
            mdstore.replace(regex, replace);
        } else {
            model.addAttribute("regex", (Object)regex);
        }
        return "redirect:mdstore.do?id=" + id;
    }

    @RequestMapping(value={"/inspector/mdstoreEditResult.do"})
    public void mdstoreEditRecord(Model model, @RequestParam(value="mdId") String mdId, @RequestParam(value="docId") String docId) throws MDStoreServiceException {
        MDStore mdstore = this.dao.getMDStore(mdId);
        String record = mdstore.getRecord(docId);
        log.debug((Object)("Displaying record for editing :" + record));
        model.addAttribute("mdId", (Object)mdId);
        TryIndentXmlString tryIndent = new TryIndentXmlString();
        String escaped = tryIndent.evaluate(record);
        model.addAttribute("body", (Object)escaped.replace("&", "&amp;"));
    }

    @RequestMapping(value={"/inspector/mdstoreSaveRecord.do"})
    public String mdstoreSaveRecord(Model model, @RequestParam(value="mdId") String mdId, @RequestParam(value="body") String body) throws MDStoreServiceException {
        MDStore mdstore = this.dao.getMDStore(mdId);
        mdstore.feed((Iterable)Lists.newArrayList((Object[])new String[]{body}), true);
        return "redirect:mdstore.do?id=" + mdId;
    }

    @RequestMapping(value={"/inspector/mdstoreDeleteRecord.do"})
    public String mdstoreDeleteRecord(Model model, @RequestParam(value="mdId") String mdId, @RequestParam(value="docId") String docId) throws MDStoreServiceException {
        MDStore mdstore = this.dao.getMDStore(mdId);
        log.info((Object)("deleting record " + docId));
        mdstore.deleteRecord(docId);
        return "redirect:mdstore.do?id=" + mdId;
    }

    @RequestMapping(value={"/inspector/mdstoresRefreshSizes.do"})
    public String mdstoresRefreshSizes(Model model) throws MDStoreServiceException {
        for (MDStoreDescription mdstore : this.dao.listMDStores()) {
            this.feeder.touchSize(mdstore.getId(), this.dao.getMDStore(mdstore.getId()).getSize());
        }
        return "redirect:mdstores.do";
    }

    @RequestMapping(value={"/inspector/ensure.do"})
    public String mdstoreEnsureIndex(Model model, @RequestParam(value="id") String mdId) throws MDStoreServiceException {
        MongoMDStore mdStore = (MongoMDStore)this.dao.getMDStore(mdId);
        log.info((Object)("manual ensureIndex for mdId: " + mdId));
        mdStore.ensureIndices();
        return "redirect:mdstores.do";
    }

    @RequestMapping(value={"/inspector/infoTransaction.do"})
    public void mdstoreInfoTransaction(Model model, @RequestParam(value="id") String id) throws MDStoreServiceException {
        MDStoreManagerInfo info = this.transactionManager.getInfoForCurrentMdStore(id);
        model.addAttribute("info", (Object)info);
    }

    @RequestMapping(value={"/inspector/dropUsedCollection.do"})
    public String dropUsedCollection(Model model, @RequestParam(value="mdId") String mdId, @RequestParam(value="id") String id) throws MDStoreServiceException {
        this.transactionManager.dropUsed(mdId, id);
        return "redirect:mdstore.do?id=" + mdId;
    }

    @RequestMapping(value={"/inspector/invalidTransactionCollection.do"})
    public String invalidTransactionCollection(Model model, @RequestParam(value="mdId") String mdId, @RequestParam(value="id") String id) throws MDStoreServiceException {
        this.transactionManager.dropTransaction(mdId, id);
        return "redirect:mdstore.do?id=" + mdId;
    }

    @RequestMapping(value={"/inspector/refreshSizes.do"})
    public String refreshSizes(Model model) throws MDStoreServiceException {
        this.dao.refreshSizes();
        return "redirect:mdstores.do";
    }

    @RequestMapping(value={"/inspector/doGarbage.do"})
    public String doGarbage(Model model) throws MDStoreServiceException {
        this.dao.startGarbage();
        return "redirect:mdstores.do";
    }
}

