/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.client;

import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.beans.factory.annotation.Required;

public class ResultSetClientFactory
implements ResultSetClient {
    private static final Log log = LogFactory.getLog(ResultSetClientFactory.class);
    private static final long DEFAULT_CONNECT_TIMEOUT = 10000L;
    private static final long DEFAULT_REQUEST_TIMEOUT = 60000L;
    private static final int DEFAULT_PAGE_SIZE = 100;
    private ServiceResolver serviceResolver;
    private EPRUtils eprUtils;
    private int pageSize;
    private long timeout;
    private long connectTimeout;

    public ResultSetClientFactory() {
        this(100, 60000L, 10000L);
    }

    public ResultSetClientFactory(int pageSize, long timeout) throws IllegalArgumentException {
        this(pageSize, timeout, 10000L);
    }

    public ResultSetClientFactory(int pageSize, long timeout, long connectTimeout) throws IllegalArgumentException {
        if (pageSize <= 0 || timeout <= 0L || connectTimeout <= 0L) {
            throw new IllegalArgumentException("parameters pageSize, timeout and connectTimeout must be greater than zero");
        }
        log.info((Object)String.format("creating new ResultSetClientIterableFactory with pageSize (%s), read timeout (%s) and connect timeout (%s)", pageSize, timeout, connectTimeout));
        this.pageSize = pageSize;
        this.timeout = timeout;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public IterableResultSetClient getClient(W3CEndpointReference epr, int pageSize) {
        ResultSetService resultSet = this.getResultSetService(epr, this.getConnectTimeout(), this.getTimeout());
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        return new IterableResultSetClient(resultSet, rsId, pageSize, this.getTimeout());
    }

    @Override
    public IterableResultSetClient getClient(W3CEndpointReference epr) {
        ResultSetService resultSet = this.getResultSetService(epr, this.getConnectTimeout(), this.getTimeout());
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        return new IterableResultSetClient(resultSet, rsId, this.getPageSize(), this.getTimeout());
    }

    private ResultSetService getResultSetService(W3CEndpointReference epr, long connectTimeout, long requestTimeout) {
        ResultSetService service = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("creting resultSet service stub with connectTimeout(%s), requestTimeout(%s)", connectTimeout, requestTimeout));
        }
        if (service instanceof Client) {
            Client client = ClientProxy.getClient((Object)service);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout(connectTimeout);
            httpClientPolicy.setAllowChunking(false);
            httpClientPolicy.setReceiveTimeout(requestTimeout);
            http.setClient(httpClientPolicy);
        }
        return service;
    }

    @Override
    public IterableResultSetClient getClient(String stringEpr, int pageSize) {
        return this.getClient(this.eprUtils.getEpr(stringEpr), pageSize);
    }

    @Override
    public IterableResultSetClient getClient(String stringEpr) {
        return this.getClient(this.eprUtils.getEpr(stringEpr));
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    @Required
    public void setEprUtils(EPRUtils eprUtils) {
        this.eprUtils = eprUtils;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Required
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Required
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

