/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.client;

import eu.dnetlib.enabling.resultset.client.ResultSetPageProvider;
import eu.dnetlib.enabling.resultset.client.utils.ResultSetRuntimeException;
import eu.dnetlib.enabling.resultset.client.utils.ResultSetTimeoutException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetClientIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(ResultSetClientIterator.class);
    private ResultSetPageProvider pageProvider;
    private Queue<String> buffer;

    public ResultSetClientIterator(ResultSetService resultSet, String rsId) throws ResultSetRuntimeException {
        this.pageProvider = new ResultSetPageProvider(resultSet, rsId);
        this.buffer = new LinkedList<String>();
    }

    public ResultSetClientIterator(ResultSetService resultSet, String rsId, int pageSize) {
        this(resultSet, rsId);
        this.pageProvider.setPageSize(pageSize);
    }

    public ResultSetClientIterator(ResultSetService resultSet, String rsId, int pageSize, long timeout) {
        this(resultSet, rsId, pageSize);
        this.pageProvider.setMaxWaitTime(timeout);
    }

    private boolean refillBuffer() throws ResultSetTimeoutException, ResultSetRuntimeException {
        List<String> page = this.pageProvider.nextPage();
        if (page != null && !page.isEmpty()) {
            this.buffer.addAll(page);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        if (!this.buffer.isEmpty()) {
            return true;
        }
        return this.refillBuffer();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            log.info((Object)"NoSuchElementException");
            throw new NoSuchElementException();
        }
        return this.buffer.poll();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

