/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.push;

import eu.dnetlib.enabling.resultset.AbstractObservableResultset;
import eu.dnetlib.enabling.resultset.push.PushResultSet;
import eu.dnetlib.enabling.resultset.push.TransientPushResultSetDao;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransientPushResultSetImpl
extends AbstractObservableResultset
implements PushResultSet {
    private static final Log log = LogFactory.getLog(TransientPushResultSetImpl.class);
    private final transient TransientPushResultSetDao dao;
    private String identifier;

    public TransientPushResultSetImpl(TransientPushResultSetDao dao) {
        this.dao = dao;
        this.setOpen(true);
    }

    @Override
    public void addElements(List<String> elements) {
        log.debug((Object)("adding to push RS: " + elements));
        if (!this.isOpen()) {
            throw new IllegalStateException("cannot write to a closed push resultset");
        }
        this.dao.addElements(this.getIdentifier(), elements);
    }

    @Override
    public int getNumberOfResults() {
        return this.dao.getSize(this.getIdentifier());
    }

    @Override
    public List<String> getResults(int fromPosition, int toPosition) {
        int size = this.getNumberOfResults();
        int toPos = toPosition;
        int fromPos = fromPosition;
        if (fromPos > size) {
            fromPos = size;
        }
        if (toPos > size) {
            toPos = size;
        }
        log.debug((Object)("calling get elements: " + this.getIdentifier() + " from " + fromPos + " to " + toPos));
        return this.dao.getElements(this.getIdentifier(), fromPos, toPos);
    }

    public TransientPushResultSetDao getDao() {
        return this.dao;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

