/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.locators;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.common.rmi.BaseService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.ServiceRunningInstance;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.enabling.tools.registration.ValidatingServiceRegistrationManagerImpl;
import eu.dnetlib.miscutils.collections.EnsureCollection;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultUniqueServiceLocator
implements UniqueServiceLocator,
ApplicationContextAware {
    private ApplicationContext appContext;
    private Comparator<ServiceRunningInstance> defaultComparator;
    @Autowired
    private ISLookUpService isLookupService;
    @Autowired
    private ServiceNameResolver serviceNameResolver;
    private SAXReader reader = new SAXReader();
    @Autowired
    private StandaloneCxfEndpointReferenceBuilder eprBuilder;
    private static final Log log = LogFactory.getLog(DefaultUniqueServiceLocator.class);

    @Override
    public <T extends BaseService> T getService(Class<T> clazz) {
        return this.getService(clazz, true);
    }

    @Override
    public <T extends BaseService> T getService(Class<T> clazz, Comparator<ServiceRunningInstance> comparator) {
        String serviceName = this.serviceNameResolver.getName(clazz);
        return this.findRunningInstances(serviceName, comparator).get(0).obtainClient(clazz, this.eprBuilder);
    }

    @Override
    public <T extends BaseService> T getService(Class<T> clazz, String profileId) {
        String profile = this.obtainServiceProfile(profileId);
        try {
            return this.obtainRunningInstance(profile, this.obtainLocalServices()).obtainClient(clazz, this.eprBuilder);
        }
        catch (Exception e) {
            log.error((Object)("cannot instantiate service from id: " + profileId), (Throwable)e);
            throw new IllegalStateException("cannot instantiate service from id: " + profileId, e);
        }
    }

    @Override
    public <T extends BaseService> T getService(Class<T> clazz, boolean local) {
        if (clazz.isInstance(this.isLookupService)) {
            return (T)((BaseService)clazz.cast(this.isLookupService));
        }
        if (local) {
            try {
                Map beans = this.appContext.getBeansOfType(clazz);
                if (beans != null && !beans.isEmpty()) {
                    return (T)((BaseService)beans.values().iterator().next());
                }
            }
            catch (Throwable e) {
                log.warn((Object)("No beans found in context, class " + clazz));
            }
        }
        return this.getService(clazz, this.defaultComparator);
    }

    @Override
    public <T extends BaseService> String getServiceId(Class<T> clazz) {
        return this.getServiceId(clazz, this.defaultComparator);
    }

    @Override
    public <T extends BaseService> String getServiceId(Class<T> clazz, Comparator<ServiceRunningInstance> comparator) {
        return this.findRunningInstances(this.serviceNameResolver.getName(clazz), comparator).get(0).getServiceId();
    }

    @Override
    public <T extends BaseService> String getServiceId(Class<T> clazz, String profileId) {
        String profile = this.obtainServiceProfile(profileId);
        ServiceRunningInstance instance = this.obtainRunningInstance(profile, this.obtainLocalServices());
        return instance.getServiceId();
    }

    @Override
    public <T extends BaseService> Set<T> getAllServices(Class<T> clazz) {
        HashSet res = Sets.newHashSet();
        for (ServiceRunningInstance instance : this.findRunningInstances(this.serviceNameResolver.getName(clazz), null)) {
            res.add(instance.obtainClient(clazz, this.eprBuilder));
        }
        return res;
    }

    @Override
    public <T extends BaseService> Set<String> getAllServiceIds(Class<T> clazz) {
        HashSet res = Sets.newHashSet();
        for (ServiceRunningInstance instance : this.findRunningInstances(this.serviceNameResolver.getName(clazz), null)) {
            res.add(instance.getServiceId());
        }
        return res;
    }

    private synchronized <T extends BaseService> ServiceRunningInstance obtainRunningInstance(String profile, Map<String, BaseService> locals) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(profile));
            String url = doc.valueOf("//PROTOCOL[@name = 'SOAP']/@address");
            String id = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
            HashMap props = Maps.newHashMap();
            BaseService local = locals.containsKey(id) ? locals.get(id) : null;
            int usedDiskpace = NumberUtils.toInt((String)doc.valueOf("//USED_DISKSPACE"), (int)0);
            int handledDatastructures = NumberUtils.toInt((String)doc.valueOf("//HANDLED_DATASTRUCTURE"), (int)0);
            for (Object o : doc.selectNodes("//SERVICE_PROPERTIES/PROPERTY")) {
                Element p = (Element)o;
                props.put(p.valueOf("@key"), p.valueOf("@value"));
            }
            return new ServiceRunningInstance(id, url, local, usedDiskpace, handledDatastructures, props);
        }
        catch (DocumentException e) {
            log.error((Object)("Error parsing profile: " + profile), (Throwable)e);
            throw new RuntimeException("Error parsing profile: " + profile, e);
        }
    }

    private List<ServiceRunningInstance> findRunningInstances(String serviceName, Comparator<ServiceRunningInstance> comparator) {
        List<ServiceRunningInstance> list = this.findRegisteredServices(serviceName);
        if (list.isEmpty()) {
            log.error((Object)("Service not found, name: " + serviceName));
            throw new RuntimeException("Service not found, name: " + serviceName);
        }
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
        return list;
    }

    private List<ServiceRunningInstance> findRegisteredServices(String serviceName) {
        log.debug((Object)("searching for service: " + serviceName));
        String xquery = "for $x in collection('/db/DRIVER/ServiceResources/" + serviceName + "ResourceType') return $x";
        log.debug((Object)xquery);
        try {
            List services = this.isLookupService.quickSearchProfile(xquery);
            ArrayList instances = Lists.newArrayList();
            Map<String, BaseService> locals = this.obtainLocalServices();
            for (String source : EnsureCollection.list((List)services)) {
                ServiceRunningInstance instance = this.obtainRunningInstance(source, locals);
                instances.add(instance);
            }
            return instances;
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot locate service " + serviceName, e);
        }
    }

    private Map<String, BaseService> obtainLocalServices() {
        HashMap locals = Maps.newHashMap();
        for (ValidatingServiceRegistrationManagerImpl r : this.appContext.getBeansOfType(ValidatingServiceRegistrationManagerImpl.class).values()) {
            BaseService baseService;
            if (!(r.getService() instanceof BaseService) || StringUtils.isBlank((String)r.getProfileId()) || (baseService = (BaseService)r.getService()) == null) continue;
            locals.put(r.getProfileId(), baseService);
            log.debug((Object)(" -> Service: " + r.getService().getClass().getName() + " has id " + r.getServiceProfile().getResourceId()));
        }
        return locals;
    }

    private String obtainServiceProfile(String profileId) {
        StringWriter sw = new StringWriter();
        sw.append("let $uri:=/RESOURCE_PROFILE/HEADER[./RESOURCE_IDENTIFIER/@value='");
        sw.append(profileId);
        sw.append("']/RESOURCE_URI/@value/string()");
        sw.append("\n\n");
        sw.append("for $x in collection('/db/DRIVER/ServiceResources')");
        sw.append("\n");
        sw.append("where $x/RESOURCE_PROFILE/HEADER/RESOURCE_URI/@value = $uri");
        sw.append("\n");
        sw.append("return $x");
        String xq = sw.toString();
        try {
            return this.isLookupService.getResourceProfileByQuery(xq);
        }
        catch (ISLookUpException e) {
            log.error((Object)("cannot locate service using query: " + xq), (Throwable)e);
            throw new IllegalStateException("cannot locate service using query: " + xq, e);
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
    }

    public Comparator<ServiceRunningInstance> getDefaultComparator() {
        return this.defaultComparator;
    }

    @Required
    public void setDefaultComparator(Comparator<ServiceRunningInstance> defaultComparator) {
        this.defaultComparator = defaultComparator;
    }

    public ISLookUpService getIsLookupService() {
        return this.isLookupService;
    }

    public void setIsLookupService(ISLookUpService isLookupService) {
        this.isLookupService = isLookupService;
    }

    public ServiceNameResolver getServiceNameResolver() {
        return this.serviceNameResolver;
    }

    public void setServiceNameResolver(ServiceNameResolver serviceNameResolver) {
        this.serviceNameResolver = serviceNameResolver;
    }
}

