/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import com.google.common.collect.Maps;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.ServiceRunningInstance;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Deprecated
public abstract class AbstractServiceLocator<T>
implements ServiceLocator<T> {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookUpLocator;
    @Resource
    private StandaloneCxfEndpointReferenceBuilder eprBuilder;
    @Resource(name="serviceResolver")
    private ServiceResolver serviceResolver;
    private static final Log log = LogFactory.getLog(AbstractServiceLocator.class);

    @Override
    public T getService(String profileId, Class<T> clazz) {
        String profile = this.executeQuery(profileId, null);
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(profile)));
            String url = xpath.evaluate("//url", doc);
            String serviceId = xpath.evaluate("//id", doc);
            NodeList propElements = (NodeList)xpath.evaluate("//PROPERTY", doc, XPathConstants.NODESET);
            HashMap props = Maps.newHashMap();
            for (int i = 0; i < propElements.getLength(); ++i) {
                Element propElement = (Element)propElements.item(i);
                props.put(propElement.getAttribute("key"), propElement.getAttribute("value"));
            }
            W3CEndpointReference epr = this.eprBuilder.getEndpointReference(url, null, null, url + "?wsdl", null, null);
            ServiceRunningInstance instance = new ServiceRunningInstance(epr, serviceId, url, props);
            return (T)this.serviceResolver.getService(clazz, instance.getEpr());
        }
        catch (Exception e) {
            log.error((Object)("cannot instantiate service from id: " + profileId), (Throwable)e);
            throw new IllegalStateException("cannot instantiate service from id: " + profileId, e);
        }
    }

    @Override
    public String getServiceId(String profileId) {
        return this.executeQuery(profileId, "/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER/@value/string()");
    }

    private String executeQuery(String profileId, String xpath) {
        StringWriter sw = new StringWriter();
        sw.append("let $uri:=/RESOURCE_PROFILE/HEADER[./RESOURCE_IDENTIFIER/@value='");
        sw.append(profileId);
        sw.append("']/RESOURCE_URI/@value/string()");
        sw.append("\n\n");
        sw.append("for $x in collection('/db/DRIVER/ServiceResources')/RESOURCE_PROFILE/HEADER");
        sw.append("\n");
        sw.append("where $x/RESOURCE_PROFILE/HEADER/RESOURCE_URI/@value = $uri");
        sw.append("\n");
        sw.append("return $x");
        if (xpath != null) {
            sw.append(xpath);
        }
        String xq = sw.toString();
        try {
            return this.lookUpLocator.getService().getResourceProfileByQuery(xq);
        }
        catch (ISLookUpException e) {
            log.error((Object)("cannot locate service using query: " + xq), (Throwable)e);
            throw new IllegalStateException("cannot locate service using query: " + xq, e);
        }
    }
}

