/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceEnumerator;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceRunningInstance;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.miscutils.collections.EnsureCollection;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
public class DynamicServiceEnumerator<T>
implements ServiceEnumerator<T> {
    private static final Log log = LogFactory.getLog(DynamicServiceEnumerator.class);
    private Class<T> clazz;
    private ServiceLocator<ISLookUpService> lookUpLocator;
    @Resource
    private ServiceNameResolver serviceNameResolver;
    @Resource
    private StandaloneCxfEndpointReferenceBuilder eprBuilder;

    public DynamicServiceEnumerator() {
    }

    public DynamicServiceEnumerator(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public List<ServiceRunningInstance<T>> getServices() {
        String serviceName = this.serviceNameResolver.getName(this.clazz);
        log.debug((Object)("searching for service: " + serviceName));
        String xquery = "for $x in collection('/db/DRIVER/ServiceResources')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value/string() = '" + serviceName + "ResourceType'] return <service><id>{$x//RESOURCE_IDENTIFIER/@value/string()}</id><url>{$x//PROTOCOL[@name = 'SOAP']/@address/string()}</url><properties>{$x//SERVICE_PROPERTIES/PROPERTY}</properties></service>";
        log.debug((Object)xquery);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            List services = this.lookUpLocator.getService().quickSearchProfile(xquery);
            ArrayList<ServiceRunningInstance<T>> instances = new ArrayList<ServiceRunningInstance<T>>();
            for (String source : EnsureCollection.list((List)services)) {
                Document doc = docBuilder.parse(new InputSource(new StringReader(source)));
                String url = xpath.evaluate("//url", doc);
                String serviceId = xpath.evaluate("//id", doc);
                NodeList propElements = (NodeList)xpath.evaluate("//PROPERTY", doc, XPathConstants.NODESET);
                HashMap<String, String> props = new HashMap<String, String>();
                for (int i = 0; i < propElements.getLength(); ++i) {
                    Element propElement = (Element)propElements.item(i);
                    props.put(propElement.getAttribute("key"), propElement.getAttribute("value"));
                }
                W3CEndpointReference epr = this.eprBuilder.getEndpointReference(url, null, null, url + "?wsdl", null, null);
                instances.add(new ServiceRunningInstance(epr, serviceId, url, props));
            }
            return instances;
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("cannot locate service " + serviceName, e);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("cannot locate service " + serviceName, e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("cannot locate service " + serviceName, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot locate service " + serviceName, e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("cannot locate service " + serviceName, e);
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    @Required
    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public ServiceLocator<ISLookUpService> getLookUpLocator() {
        return this.lookUpLocator;
    }

    public void setLookUpLocator(ServiceLocator<ISLookUpService> lookUpLocator) {
        this.lookUpLocator = lookUpLocator;
    }

    public ServiceNameResolver getServiceNameResolver() {
        return this.serviceNameResolver;
    }

    public void setServiceNameResolver(ServiceNameResolver serviceNameResolver) {
        this.serviceNameResolver = serviceNameResolver;
    }

    public StandaloneCxfEndpointReferenceBuilder getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(StandaloneCxfEndpointReferenceBuilder eprBuilder) {
        this.eprBuilder = eprBuilder;
    }
}

