/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.collections.PositionalStringMapGenerator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public class SplittedQueryExecutor {
    private UniqueServiceLocator serviceLocator;

    public SplittedQueryExecutor() {
    }

    public SplittedQueryExecutor(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public <X> Iterable<X> query(Class<X> clazz, String query) {
        return this.query(clazz, query, ":-:");
    }

    public <X> Iterable<X> query(Class<X> clazz, String query, String separator) {
        return new PositionalStringMapGenerator((Object[])new String[0]).split(clazz, this.performQuery(query), separator);
    }

    public Iterable<Map<String, String>> query(String query, String ... keys) {
        return new PositionalStringMapGenerator((Object[])keys).split(this.performQuery(query), ":-:");
    }

    public Iterable<Map<String, String>> mutableQuery(String query, String ... keys) {
        return Lists.newArrayList(this.query(query, keys));
    }

    public <X> Iterable<X> mutableQuery(Class<X> clazz, String query) {
        return Lists.newArrayList(this.query(clazz, query));
    }

    public <X> Iterable<X> mutableQuery(Class<X> clazz, String query, String separator) {
        return Lists.newArrayList(this.query(clazz, query, separator));
    }

    public List<String> performQuery(String query) {
        try {
            return this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(query);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    public String queryFirst(String query) {
        try {
            return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

