/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.registration;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.enabling.tools.registration.ServiceRegistrationManager;
import eu.dnetlib.enabling.tools.registration.ServiceRegistrator;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Endpoint;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public class ServiceRegistrationManagerImpl
implements ServiceRegistrationManager {
    private static final String PROFILE_NOT_FOUND = "profile not found";
    private static final String ERROR_CHECK = "error checking profile";
    private static final Log log = LogFactory.getLog(ServiceRegistrationManagerImpl.class);
    private String profileId;
    private Object service;
    private Endpoint endpoint;
    private UniqueServiceLocator serviceLocator;
    private ServiceRegistrator registrator;
    private OpaqueResource serviceProfile;
    private boolean schemaUpdate = true;
    private boolean disabled = false;
    private State state = State.UNKNOWN;

    void checkExisting() {
        String uri = this.registrator.getEprBuilder().getAddress((Object)this.endpoint) + "?wsdl";
        String query = "for $x in //RESOURCE_PROFILE[.//RESOURCE_URI/@value='" + uri + "'] where contains($x//RESOURCE_TYPE/@value/string(), 'Service') return $x";
        try {
            StringOpaqueResource resource = new StringOpaqueResource(this.serviceLocator.getService(ISLookUpService.class, true).getResourceProfileByQuery(query));
            if ("PendingServiceResources".equals(resource.getResourceKind())) {
                this.state = State.PENDING;
            } else {
                this.setProfileId(resource.getResourceId());
                this.setServiceProfile(resource);
                this.state = State.REGISTERED;
            }
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)("there is no service registered for uri: " + uri));
            this.state = State.UNREGISTERED;
        }
        catch (ISLookUpException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (SAXException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
    }

    void checkPending() {
        log.debug((Object)("checking pending status: " + this.getService()));
        String uri = this.serviceProfile.getResourceUri();
        String query = "collection('')//RESOURCE_PROFILE[.//RESOURCE_URI/@value='" + uri + "']";
        try {
            StringOpaqueResource resource = new StringOpaqueResource(this.serviceLocator.getService(ISLookUpService.class, true).getResourceProfileByQuery(query));
            if (!"PendingServiceResources".equals(resource.getResourceKind())) {
                this.setProfileId(resource.getResourceId());
                this.setServiceProfile(resource);
                this.state = State.REGISTERED;
            }
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)PROFILE_NOT_FOUND, (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (SAXException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
    }

    public void registerService() {
        log.debug((Object)("registering service profile: " + this.getService()));
        this.setProfileId(this.getRegistrator().registerService(this.getService(), this.getEndpoint()));
        if (this.getProfileId() == null) {
            log.debug((Object)"cannot register profile, no hnm");
            return;
        }
        log.debug((Object)("Service profile registered: " + this.getProfileId()));
        this.retrieveServiceProfile();
        this.state = State.PENDING;
        if (this.getProfileId() == null) {
            throw new IllegalStateException("cannot be true, I'm dreaming");
        }
    }

    public void registerSchema() {
        this.getRegistrator().registerServiceSchema(this.getService());
    }

    private void retrieveServiceProfile() {
        log.debug((Object)("Retrieving service profile: " + this.getProfileId()));
        try {
            this.setServiceProfile(new StringOpaqueResource(this.serviceLocator.getService(ISLookUpService.class, true).getResourceProfile(this.getProfileId())));
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)PROFILE_NOT_FOUND, (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (XPathExpressionException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (SAXException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.warn((Object)ERROR_CHECK, (Throwable)e);
        }
    }

    @Override
    public OpaqueResource getServiceProfile() {
        this.retrieveServiceProfile();
        return this.serviceProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.disabled) {
            return;
        }
        ServiceRegistrator serviceRegistrator = this.registrator;
        synchronized (serviceRegistrator) {
            if (this.state != State.REGISTERED) {
                log.debug((Object)("checking service profile registration: " + this.getService() + " (" + (Object)((Object)this.state) + ")"));
            }
            if (this.state == State.UNKNOWN) {
                if (this.schemaUpdate) {
                    this.registerSchema();
                }
                this.checkExisting();
            } else if (this.state == State.UNREGISTERED) {
                this.registerService();
            } else if (this.state == State.PENDING) {
                this.checkPending();
            }
            if (this.state != State.REGISTERED) {
                log.debug((Object)"tick finished");
            }
        }
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    @Override
    public Object getService() {
        return this.service;
    }

    @Override
    public void setService(Object service) {
        this.service = service;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public ServiceRegistrator getRegistrator() {
        return this.registrator;
    }

    @Required
    public void setRegistrator(ServiceRegistrator registrator) {
        this.registrator = registrator;
    }

    public void setServiceProfile(OpaqueResource serviceProfile) {
        this.serviceProfile = serviceProfile;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isSchemaUpdate() {
        return this.schemaUpdate;
    }

    public void setSchemaUpdate(boolean schemaUpdate) {
        this.schemaUpdate = schemaUpdate;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public static enum State {
        UNKNOWN,
        UNREGISTERED,
        PENDING,
        REGISTERED;

    }
}

