/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.store;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.is.store.BulkResourceImporter;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.StreamOpaqueResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public class AbstractContentInitializer {
    private static final Log log = LogFactory.getLog(AbstractContentInitializer.class);
    private UniqueServiceLocator serviceLocator;
    private BulkResourceImporter bulkImporter;
    private int timeToSleep;

    protected void registerSchema(URL url) throws IOException, ISRegistryException {
        String resourceType = FilenameUtils.getBaseName((String)url.getPath());
        log.debug((Object)("registering schema: " + resourceType));
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)url.openStream(), (Writer)writer);
        ISRegistryService service = null;
        while (service == null) {
            try {
                service = this.serviceLocator.getService(ISRegistryService.class, true);
                service.addResourceType(resourceType, writer.getBuffer().toString());
                log.info((Object)"The is registry service is ready ");
            }
            catch (Exception e) {
                log.fatal((Object)"The is registry service is not ready ", (Throwable)e);
                try {
                    Thread.sleep(this.timeToSleep);
                }
                catch (InterruptedException e1) {
                    log.error((Object)e1);
                }
            }
        }
    }

    protected void registerProfile(URL url) throws IOException, ISRegistryException, XPathExpressionException, SAXException, ParserConfigurationException {
        log.debug((Object)("registering profile: " + url));
        this.bulkImporter.importResource(new StreamOpaqueResource(url.openStream()));
    }

    @Required
    public void setBulkImporter(BulkResourceImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public BulkResourceImporter getBulkImporter() {
        return this.bulkImporter;
    }

    public int getTimeToSleep() {
        return this.timeToSleep;
    }

    @Required
    public void setTimeToSleep(int timeToSleep) {
        this.timeToSleep = timeToSleep;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

