/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.controller;

import eu.dnetlib.bioschemas.api.scraper.ScrapingExecution;
import eu.dnetlib.bioschemas.api.scraper.ScrapingExecutor;
import eu.dnetlib.bioschemas.api.utils.BioschemasException;
import eu.dnetlib.common.controller.AbstractDnetController;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BioschemasAPIController
extends AbstractDnetController {
    @Value(value="${outputFolder}")
    private String outputFolder;
    @Value(value="${outputDataPattern}")
    private String outputDataPattern;
    private static Logger logger = LoggerFactory.getLogger(BioschemasAPIController.class);
    @Autowired
    private ScrapingExecutor scrapingExecutor;
    private static final Log log = LogFactory.getLog(BioschemasAPIController.class);

    @GetMapping(value={"/startScraping"})
    public ScrapingExecution startScraping(@RequestParam String datasourceKey, @RequestParam String sitemapUrl, HttpServletRequest req) {
        logger.info("<STARTSCRAPING> datasourceKey: " + datasourceKey + " sitemapUrl:" + sitemapUrl);
        return this.scrapingExecutor.startScraping(datasourceKey, sitemapUrl, this.getOutputDataPattern(), req.getRemoteAddr(), this.getOutputFolder());
    }

    @GetMapping(value={"/startScraping/status"})
    public final ScrapingExecution statusScraping() {
        return this.scrapingExecutor.getLastScrapingExecution();
    }

    @RequestMapping(value={"/getNQuads"}, method={RequestMethod.GET})
    public String getNQuads(@RequestParam String datasourceKey, HttpServletResponse response) throws BioschemasException, IOException {
        logger.info("<GETNQUADS> datasourceKey: " + datasourceKey);
        LineIterator it = FileUtils.lineIterator((File)new File(this.getOutputFolder().concat("/").concat(datasourceKey).concat(this.getOutputDataPattern())), (String)"UTF-8");
        while (it.hasNext()) {
            String line = it.nextLine();
            response.getOutputStream().write(line.getBytes(StandardCharsets.UTF_8));
            response.getOutputStream().println();
        }
        return "";
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getOutputDataPattern() {
        return this.outputDataPattern;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setOutputDataPattern(String outputDataPattern) {
        this.outputDataPattern = outputDataPattern;
    }
}

