/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.scraper;

import hwu.elixir.scrape.exceptions.MissingMarkupException;
import hwu.elixir.scrape.scraper.ScraperFilteredCore;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.source.StringDocumentSource;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BMUSEScraper
extends ScraperFilteredCore {
    private static Logger logger = LoggerFactory.getLogger(BMUSEScraper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNQUADSFromUrl(String url, Boolean dynamic) throws Exception {
        logger.debug(url + " > scraping");
        url = this.fixURL(url);
        String html = "";
        html = dynamic != false ? this.wrapHTMLExtraction(url) : this.wrapHTMLExtractionStatic(url);
        if (html == null) throw new Exception("empty html");
        if (html.contentEquals("")) {
            throw new Exception("empty html");
        }
        html = this.injectId(html, url);
        logger.debug(url + " > html scraped from " + url);
        StringDocumentSource source = new StringDocumentSource(html, url);
        String n3 = this.html2Triples((DocumentSource)source, url);
        if (n3 == null) {
            throw new MissingMarkupException(url);
        }
        logger.debug(url + " > processing triples");
        IRI sourceIRI = SimpleValueFactory.getInstance().createIRI(source.getDocumentIRI());
        Model updatedModel = this.processTriples(n3, sourceIRI, Long.valueOf(0L));
        if (updatedModel == null) {
            throw new Exception("rdf model null");
        }
        logger.debug(url + " > generating nquads");
        try (StringWriter jsonLDWriter = new StringWriter();){
            Rio.write((Iterable)updatedModel, (Writer)jsonLDWriter, (RDFFormat)RDFFormat.NQUADS);
            logger.debug(url + " > nquads generated");
            String string = jsonLDWriter.toString();
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private String html2Triples(DocumentSource source, String url) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

