/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.crawl;

import eu.dnetlib.bioschemas.api.crawl.StatusOfScrape;
import hwu.elixir.utils.Validation;
import java.util.Date;

public class CrawlRecord {
    private Long id;
    private String context = "";
    private String url;
    private Date dateScraped;
    private StatusOfScrape status;
    private boolean beingScraped;
    private String name;
    private String nquads;

    public CrawlRecord() {
        this.status = StatusOfScrape.UNTRIED;
    }

    public CrawlRecord(String url) {
        Validation validation = new Validation();
        if (!validation.validateURI(url)) {
            throw new IllegalArgumentException(url + " is not a valid url");
        }
        this.url = url;
        this.context = "";
        this.status = StatusOfScrape.UNTRIED;
        this.dateScraped = null;
        this.setId(Long.valueOf(System.currentTimeMillis()));
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public Date getDateScraped() {
        return this.dateScraped;
    }

    public void setDateScraped(Date dateScraped) {
        this.dateScraped = dateScraped;
    }

    public StatusOfScrape getStatus() {
        return this.status;
    }

    public void setStatus(StatusOfScrape status) {
        this.status = status;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public boolean isBeingScraped() {
        return this.beingScraped;
    }

    public void setBeingScraped(boolean beingScraped) {
        this.beingScraped = beingScraped;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNquads() {
        return this.nquads;
    }

    public void setNquads(String nquads) {
        this.nquads = nquads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrawlRecord)) {
            return false;
        }
        CrawlRecord otherCrawl = (CrawlRecord)o;
        return this.url.equals(otherCrawl.getUrl());
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getUrl() != null ? this.getUrl().hashCode() : 0);
        result = 31 * result + (this.getContext() != null ? this.getContext().hashCode() : 0);
        result = 31 * result + (this.getDateScraped() != null ? this.getDateScraped().hashCode() : 0);
        return result;
    }
}

