/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.utils;

import hwu.elixir.utils.Helpers;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlParser {
    private static final Logger logger = LoggerFactory.getLogger((String)UrlParser.class.getName());

    public static Elements getSitemapList(String url, String sitemapURLKey) throws IOException {
        Document doc = new Document(url);
        Elements elements = new Elements();
        Elements sitemaps = new Elements();
        boolean sitemapindex = false;
        boolean urlset = false;
        try {
            int urlLength = url.length();
            logger.info("parse sitemap list");
            String sitemapExt = url.substring(urlLength - 3, urlLength);
            if (sitemapExt.equalsIgnoreCase(".gz")) {
                logger.info("compressed sitemap");
                byte[] bytes = Jsoup.connect((String)url).ignoreContentType(true).execute().bodyAsBytes();
                doc = Helpers.gzipFileDecompression((byte[])bytes);
            } else {
                doc = Jsoup.connect((String)url).maxBodySize(0).get();
            }
        }
        catch (IOException e) {
            logger.error("Jsoup parsing exception: " + e.getMessage());
        }
        try {
            elements = doc.select(sitemapURLKey);
            sitemapindex = doc.outerHtml().contains("sitemapindex");
            urlset = doc.outerHtml().contains("urlset");
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage());
        }
        if (sitemapindex) {
            logger.warn("please note this is a sitemapindex file which is not currently supported, please use the content (url) of the urlset instead");
            sitemaps = doc.select(sitemapURLKey);
        }
        return elements;
    }
}

