/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class CompressorUtil {
    public static String decompressValue(String abstractCompressed) {
        try {
            byte[] byteArray = Base64.decodeBase64((byte[])abstractCompressed.getBytes());
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(byteArray));
            StringWriter stringWriter = new StringWriter();
            IOUtils.copy((InputStream)gis, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String compressValue(String value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(value.getBytes());
        gzip.close();
        return java.util.Base64.getEncoder().encodeToString(out.toByteArray());
    }
}

