/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.bioschemas.api.scraper;

import eu.dnetlib.bioschemas.api.scraper.ScrapingStatus;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScrapingExecution {
    private String id;
    private Long dateStart;
    private Long dateEnd;
    private ScrapingStatus status = ScrapingStatus.NOT_YET_STARTED;
    private String message;
    private static final Log log = LogFactory.getLog(ScrapingExecution.class);

    public ScrapingExecution() {
    }

    public ScrapingExecution(String id, Long dateStart, Long dateEnd, ScrapingStatus status, String message) {
        this.id = id;
        this.dateStart = dateStart;
        this.dateEnd = dateEnd;
        this.status = status;
        this.message = message;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Long dateStart) {
        this.dateStart = dateStart;
    }

    public Long getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Long dateEnd) {
        this.dateEnd = dateEnd;
    }

    public ScrapingStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScrapingStatus status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void startNew(String message) {
        this.setId("scraping-" + UUID.randomUUID());
        this.setDateStart(Long.valueOf(System.currentTimeMillis()));
        this.setDateEnd(null);
        this.setStatus(ScrapingStatus.RUNNING);
        this.setMessage(message);
        log.info((Object)message);
    }

    public void complete() {
        this.setDateEnd(Long.valueOf(System.currentTimeMillis()));
        this.setStatus(ScrapingStatus.SUCCESS);
        long millis = this.getDateEnd() - this.getDateStart();
        this.setMessage(String.format("Scraping completed in %d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis))));
        log.info((Object)this.getMessage());
    }

    public void fail(Throwable e) {
        this.setDateEnd(Long.valueOf(new Date().getTime()));
        this.setStatus(ScrapingStatus.FAILED);
        this.setMessage(e.getMessage());
        log.error((Object)"Error scraping", e);
    }
}

