/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.dhp.actionmanager.partition.PartitionActionSetsByPayloadTypeJob;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISClient
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PartitionActionSetsByPayloadTypeJob.class);
    private static final String INPUT_ACTION_SET_ID_SEPARATOR = ",";
    private final ISLookUpService isLookup;

    public ISClient(String isLookupUrl) {
        this.isLookup = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
    }

    public List<String> getLatestRawsetPaths(String setIds) {
        ArrayList ids = Lists.newArrayList((Iterable)Splitter.on((String)INPUT_ACTION_SET_ID_SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)setIds));
        return ids.stream().map(id -> this.getSet(this.isLookup, (String)id)).map(as -> as.getPathToLatest()).collect(Collectors.toCollection(ArrayList::new));
    }

    private ActionManagerSet getSet(ISLookUpService isLookup, String setId) {
        String q = "for $x in collection('/db/DRIVER/ActionManagerSetDSResources/ActionManagerSetDSResourceType') where $x//SET/@id = '" + setId + "' return $x";
        try {
            String basePath = this.getBasePathHDFS(isLookup);
            String setProfile = isLookup.getResourceProfileByQuery(q);
            return this.getActionManagerSet(basePath, setProfile);
        }
        catch (ActionManagerException | ISLookUpException e) {
            throw new RuntimeException("Error accessing Sets, using query: " + q);
        }
    }

    private ActionManagerSet getActionManagerSet(String basePath, String profile) throws ActionManagerException {
        SAXReader reader = new SAXReader();
        ActionManagerSet set = new ActionManagerSet();
        try {
            Document doc = reader.read((Reader)new StringReader(profile));
            set.setId(doc.valueOf("//SET/@id").trim());
            set.setName(doc.valueOf("//SET").trim());
            set.setImpact(ActionManagerSet.ImpactTypes.valueOf((String)doc.valueOf("//IMPACT").trim()));
            set.setLatest(doc.valueOf("//RAW_SETS/LATEST/@id"), doc.valueOf("//RAW_SETS/LATEST/@creationDate"), doc.valueOf("//RAW_SETS/LATEST/@lastUpdate"));
            set.setDirectory(doc.valueOf("//SET/@directory"));
            List expiredNodes = doc.selectNodes("//RAW_SETS/EXPIRED");
            if (expiredNodes != null) {
                for (int i = 0; i < expiredNodes.size(); ++i) {
                    Element ex = (Element)expiredNodes.get(i);
                    set.addExpired(ex.attributeValue("id"), ex.attributeValue("creationDate"), ex.attributeValue("lastUpdate"));
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(basePath);
            sb.append("/");
            sb.append(doc.valueOf("//SET/@directory"));
            sb.append("/");
            sb.append(doc.valueOf("//RAW_SETS/LATEST/@id"));
            set.setPathToLatest(sb.toString());
            return set;
        }
        catch (Exception e) {
            throw new ActionManagerException("Error creating set from profile: " + profile, (Throwable)e);
        }
    }

    private String getBasePathHDFS(ISLookUpService isLookup) throws ActionManagerException {
        return this.queryServiceProperty(isLookup, "basePath");
    }

    private String queryServiceProperty(ISLookUpService isLookup, String propertyName) throws ActionManagerException {
        String q = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ActionManagerServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + propertyName + "']/@value/string()";
        log.debug("quering for service property: " + q);
        try {
            List value = isLookup.quickSearchProfile(q);
            return (String)Iterables.getOnlyElement((Iterable)value);
        }
        catch (ISLookUpException e) {
            String msg = "Error accessing service profile, using query: " + q;
            log.error(msg, (Throwable)e);
            throw new ActionManagerException(msg, (Throwable)e);
        }
        catch (NoSuchElementException e) {
            String msg = "missing service property: " + propertyName;
            log.error(msg, (Throwable)e);
            throw new ActionManagerException(msg, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String msg = "found more than one service property: " + propertyName;
            log.error(msg, (Throwable)e);
            throw new ActionManagerException(msg, (Throwable)e);
        }
    }
}

