/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.promote;

import eu.dnetlib.dhp.actionmanager.promote.MergeAndGet;
import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class MergeAndGetTest {

    @Nested
    class SelectNewerAndGetStrategy {
        SelectNewerAndGetStrategy() {
        }

        @Test
        void shouldThrowForOafEntityAndRelation() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            Relation b = (Relation)Mockito.mock(Relation.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.SELECT_NEWER_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForRelationAndOafEntity() {
            Relation a = (Relation)Mockito.mock(Relation.class);
            OafEntity b = (OafEntity)Mockito.mock(OafEntity.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.SELECT_NEWER_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForOafEntityAndResult() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            Result b = (Result)Mockito.mock(Result.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.SELECT_NEWER_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowWhenSuperTypeIsNewerForResultAndOafEntity() {
            Dataset a = new Dataset();
            a.setLastupdatetimestamp(Long.valueOf(1L));
            Result b = new Result();
            b.setLastupdatetimestamp(Long.valueOf(2L));
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.SELECT_NEWER_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldShouldReturnLeftForOafEntityAndOafEntity() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            Mockito.when((Object)a.getLastupdatetimestamp()).thenReturn((Object)1L);
            OafEntity b = (OafEntity)Mockito.mock(OafEntity.class);
            Mockito.when((Object)b.getLastupdatetimestamp()).thenReturn((Object)2L);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.SELECT_NEWER_AND_GET);
            Oaf x = (Oaf)((BiFunction)fn.get()).apply(a, b);
            Assertions.assertTrue((boolean)OafEntity.class.isAssignableFrom(x.getClass()));
            Assertions.assertEquals((Object)b, (Object)x);
        }

        @Test
        void shouldShouldReturnRightForOafEntityAndOafEntity() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            Mockito.when((Object)a.getLastupdatetimestamp()).thenReturn((Object)2L);
            OafEntity b = (OafEntity)Mockito.mock(OafEntity.class);
            Mockito.when((Object)b.getLastupdatetimestamp()).thenReturn((Object)1L);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.SELECT_NEWER_AND_GET);
            Oaf x = (Oaf)((BiFunction)fn.get()).apply(a, b);
            Assertions.assertTrue((boolean)OafEntity.class.isAssignableFrom(x.getClass()));
            Assertions.assertEquals((Object)a, (Object)x);
        }
    }

    @Nested
    class MergeFromAndGetStrategy {
        MergeFromAndGetStrategy() {
        }

        @Test
        void shouldThrowForOafAndOaf() {
            Oaf a = (Oaf)Mockito.mock(Oaf.class);
            Oaf b = (Oaf)Mockito.mock(Oaf.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForOafAndRelation() {
            Oaf a = (Oaf)Mockito.mock(Oaf.class);
            Relation b = (Relation)Mockito.mock(Relation.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForOafAndOafEntity() {
            Oaf a = (Oaf)Mockito.mock(Oaf.class);
            OafEntity b = (OafEntity)Mockito.mock(OafEntity.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForRelationAndOaf() {
            Relation a = (Relation)Mockito.mock(Relation.class);
            Oaf b = (Oaf)Mockito.mock(Oaf.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForRelationAndOafEntity() {
            Relation a = (Relation)Mockito.mock(Relation.class);
            OafEntity b = (OafEntity)Mockito.mock(OafEntity.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldBehaveProperlyForRelationAndRelation() {
            Relation a = (Relation)Mockito.mock(Relation.class);
            Relation b = (Relation)Mockito.mock(Relation.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Oaf x = (Oaf)((BiFunction)fn.get()).apply(a, b);
            Assertions.assertTrue((boolean)Relation.class.isAssignableFrom(x.getClass()));
            ((Relation)Mockito.verify((Object)a)).mergeFrom(b);
            Assertions.assertEquals((Object)a, (Object)x);
        }

        @Test
        void shouldThrowForOafEntityAndOaf() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            Oaf b = (Oaf)Mockito.mock(Oaf.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForOafEntityAndRelation() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            Relation b = (Relation)Mockito.mock(Relation.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldThrowForOafEntityAndOafEntityButNotSubclasses() {
            class OafEntitySub1
            extends OafEntity {
                OafEntitySub1() {
                }
            }
            OafEntitySub1 a = (OafEntitySub1)((Object)Mockito.mock(OafEntitySub1.class));
            class OafEntitySub2
            extends OafEntity {
                OafEntitySub2() {
                }
            }
            OafEntitySub2 b = (OafEntitySub2)((Object)Mockito.mock(OafEntitySub2.class));
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Assertions.assertThrows(RuntimeException.class, () -> {
                Oaf cfr_ignored_0 = (Oaf)((BiFunction)fn.get()).apply(a, b);
            });
        }

        @Test
        void shouldBehaveProperlyForOafEntityAndOafEntity() {
            OafEntity a = (OafEntity)Mockito.mock(OafEntity.class);
            OafEntity b = (OafEntity)Mockito.mock(OafEntity.class);
            FunctionalInterfaceSupport.SerializableSupplier fn = MergeAndGet.functionFor((MergeAndGet.Strategy)MergeAndGet.Strategy.MERGE_FROM_AND_GET);
            Oaf x = (Oaf)((BiFunction)fn.get()).apply(a, b);
            Assertions.assertTrue((boolean)OafEntity.class.isAssignableFrom(x.getClass()));
            ((OafEntity)Mockito.verify((Object)a)).mergeFrom(b);
            Assertions.assertEquals((Object)a, (Object)x);
        }
    }
}

