/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.promote;

import eu.dnetlib.dhp.actionmanager.promote.PromoteActionPayloadFunctions;
import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class PromoteActionPayloadFunctionsTest {
    private static SparkSession spark;

    @BeforeAll
    public static void beforeAll() {
        SparkConf conf = new SparkConf();
        conf.setMaster("local");
        conf.setAppName(PromoteActionPayloadFunctionsTest.class.getSimpleName());
        conf.set("spark.driver.host", "localhost");
        spark = SparkSession.builder().config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() {
        spark.stop();
    }

    private static OafImplSub createOafImplSub(String id) {
        OafImplSub x = new OafImplSub();
        x.setId(id);
        return x;
    }

    private static OafImplSubSub createOafImplSubSub(String id) {
        OafImplSubSub x = new OafImplSubSub();
        x.setId(id);
        return x;
    }

    public static class OafImplSubSub
    extends OafImplSub {
        @Override
        public void merge(OafImplRoot e) {
            super.merge(e);
        }
    }

    public static class OafImplSub
    extends OafImplRoot {
        @Override
        public void merge(OafImplRoot e) {
            super.merge(e);
        }
    }

    public static class OafImplRoot
    extends Oaf {
        private String id;
        private int merged = 1;

        public void merge(OafImplRoot e) {
            this.merged += e.merged;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getMerged() {
            return this.merged;
        }

        public void setMerged(int merged) {
            this.merged = merged;
        }
    }

    @Nested
    class GroupTableByIdAndMerge {
        GroupTableByIdAndMerge() {
        }

        @Test
        void shouldRunProperly() {
            String id1 = "id1";
            String id2 = "id2";
            String id3 = "id3";
            List<OafImplSubSub> rowData = Arrays.asList(PromoteActionPayloadFunctionsTest.createOafImplSubSub(id1), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3));
            Dataset rowDS = spark.createDataset(rowData, Encoders.bean(OafImplSubSub.class));
            FunctionalInterfaceSupport.SerializableSupplier & Serializable rowIdFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> OafImplRoot::getId;
            FunctionalInterfaceSupport.SerializableSupplier & Serializable mergeAndGetFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> (x, y) -> {
                x.merge((OafImplRoot)((Object)((Object)((Object)y))));
                return x;
            };
            FunctionalInterfaceSupport.SerializableSupplier & Serializable zeroFn = OafImplSubSub::new;
            FunctionalInterfaceSupport.SerializableSupplier & Serializable isNotZeroFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> x -> Objects.nonNull(x.getId());
            List results = PromoteActionPayloadFunctions.groupGraphTableByIdAndMerge((Dataset)rowDS, (FunctionalInterfaceSupport.SerializableSupplier)rowIdFn, (FunctionalInterfaceSupport.SerializableSupplier)mergeAndGetFn, (FunctionalInterfaceSupport.SerializableSupplier)zeroFn, (FunctionalInterfaceSupport.SerializableSupplier)isNotZeroFn, OafImplSubSub.class).collectAsList();
            Assertions.assertEquals((int)3, (int)results.size());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id1)).count());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id2)).count());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id3)).count());
            results.forEach(result -> {
                switch (result.getId()) {
                    case "id1": {
                        Assertions.assertEquals((int)1, (int)result.getMerged());
                        break;
                    }
                    case "id2": {
                        Assertions.assertEquals((int)2, (int)result.getMerged());
                        break;
                    }
                    case "id3": {
                        Assertions.assertEquals((int)3, (int)result.getMerged());
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            });
        }
    }

    @Nested
    class JoinTableWithActionPayloadAndMerge {
        JoinTableWithActionPayloadAndMerge() {
        }

        @Test
        void shouldThrowWhenTableTypeIsNotSubtypeOfActionPayloadType() {
            Assertions.assertThrows(RuntimeException.class, () -> {
                class OafImpl
                extends Oaf {
                    OafImpl() {
                    }
                }
                PromoteActionPayloadFunctions.joinGraphTableWithActionPayloadAndMerge(null, null, null, null, null, OafImplSubSub.class, OafImpl.class);
            });
        }

        @Test
        void shouldRunProperlyWhenActionPayloadTypeAndTableTypeAreTheSame() {
            String id0 = "id0";
            String id1 = "id1";
            String id2 = "id2";
            String id3 = "id3";
            String id4 = "id4";
            List<OafImplSubSub> rowData = Arrays.asList(PromoteActionPayloadFunctionsTest.createOafImplSubSub(id0), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id1), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3));
            Dataset rowDS = spark.createDataset(rowData, Encoders.bean(OafImplSubSub.class));
            List<OafImplSubSub> actionPayloadData = Arrays.asList(PromoteActionPayloadFunctionsTest.createOafImplSubSub(id1), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id4), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id4), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id4), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id4));
            Dataset actionPayloadDS = spark.createDataset(actionPayloadData, Encoders.bean(OafImplSubSub.class));
            FunctionalInterfaceSupport.SerializableSupplier & Serializable rowIdFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> OafImplRoot::getId;
            FunctionalInterfaceSupport.SerializableSupplier & Serializable actionPayloadIdFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> OafImplRoot::getId;
            FunctionalInterfaceSupport.SerializableSupplier & Serializable mergeAndGetFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> (x, y) -> {
                x.merge((OafImplRoot)((Object)((Object)((Object)y))));
                return x;
            };
            List results = PromoteActionPayloadFunctions.joinGraphTableWithActionPayloadAndMerge((Dataset)rowDS, (Dataset)actionPayloadDS, (FunctionalInterfaceSupport.SerializableSupplier)rowIdFn, (FunctionalInterfaceSupport.SerializableSupplier)actionPayloadIdFn, (FunctionalInterfaceSupport.SerializableSupplier)mergeAndGetFn, OafImplSubSub.class, OafImplSubSub.class).collectAsList();
            Assertions.assertEquals((int)11, (int)results.size());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id0)).count());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id1)).count());
            Assertions.assertEquals((long)2L, (long)results.stream().filter(x -> x.getId().equals(id2)).count());
            Assertions.assertEquals((long)3L, (long)results.stream().filter(x -> x.getId().equals(id3)).count());
            Assertions.assertEquals((long)4L, (long)results.stream().filter(x -> x.getId().equals(id4)).count());
            results.forEach(result -> {
                switch (result.getId()) {
                    case "id0": {
                        Assertions.assertEquals((int)1, (int)result.getMerged());
                        break;
                    }
                    case "id1": 
                    case "id2": 
                    case "id3": {
                        Assertions.assertEquals((int)2, (int)result.getMerged());
                        break;
                    }
                    case "id4": {
                        Assertions.assertEquals((int)1, (int)result.getMerged());
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            });
        }

        @Test
        void shouldRunProperlyWhenActionPayloadTypeIsSuperTypeOfTableType() {
            String id0 = "id0";
            String id1 = "id1";
            String id2 = "id2";
            String id3 = "id3";
            String id4 = "id4";
            List<OafImplSubSub> rowData = Arrays.asList(PromoteActionPayloadFunctionsTest.createOafImplSubSub(id0), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id1), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSubSub(id3));
            Dataset rowDS = spark.createDataset(rowData, Encoders.bean(OafImplSubSub.class));
            List<OafImplSub> actionPayloadData = Arrays.asList(PromoteActionPayloadFunctionsTest.createOafImplSub(id1), PromoteActionPayloadFunctionsTest.createOafImplSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSub(id2), PromoteActionPayloadFunctionsTest.createOafImplSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSub(id3), PromoteActionPayloadFunctionsTest.createOafImplSub(id4), PromoteActionPayloadFunctionsTest.createOafImplSub(id4), PromoteActionPayloadFunctionsTest.createOafImplSub(id4), PromoteActionPayloadFunctionsTest.createOafImplSub(id4));
            Dataset actionPayloadDS = spark.createDataset(actionPayloadData, Encoders.bean(OafImplSub.class));
            FunctionalInterfaceSupport.SerializableSupplier & Serializable rowIdFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> OafImplRoot::getId;
            FunctionalInterfaceSupport.SerializableSupplier & Serializable actionPayloadIdFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> OafImplRoot::getId;
            FunctionalInterfaceSupport.SerializableSupplier & Serializable mergeAndGetFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> (x, y) -> {
                x.merge((OafImplRoot)((Object)((Object)((Object)y))));
                return x;
            };
            List results = PromoteActionPayloadFunctions.joinGraphTableWithActionPayloadAndMerge((Dataset)rowDS, (Dataset)actionPayloadDS, (FunctionalInterfaceSupport.SerializableSupplier)rowIdFn, (FunctionalInterfaceSupport.SerializableSupplier)actionPayloadIdFn, (FunctionalInterfaceSupport.SerializableSupplier)mergeAndGetFn, OafImplSubSub.class, OafImplSub.class).collectAsList();
            Assertions.assertEquals((int)7, (int)results.size());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id0)).count());
            Assertions.assertEquals((long)1L, (long)results.stream().filter(x -> x.getId().equals(id1)).count());
            Assertions.assertEquals((long)2L, (long)results.stream().filter(x -> x.getId().equals(id2)).count());
            Assertions.assertEquals((long)3L, (long)results.stream().filter(x -> x.getId().equals(id3)).count());
            Assertions.assertEquals((long)0L, (long)results.stream().filter(x -> x.getId().equals(id4)).count());
            results.forEach(result -> {
                switch (result.getId()) {
                    case "id0": {
                        Assertions.assertEquals((int)1, (int)result.getMerged());
                        break;
                    }
                    case "id1": 
                    case "id2": 
                    case "id3": {
                        Assertions.assertEquals((int)2, (int)result.getMerged());
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            });
        }
    }
}

