/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.promote;

import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import java.io.Serializable;
import java.util.function.BiFunction;

public class MergeAndGet {
    private MergeAndGet() {
    }

    public static <G extends Oaf, A extends Oaf> FunctionalInterfaceSupport.SerializableSupplier<BiFunction<G, A, G>> functionFor(Strategy mergeStrategy) {
        switch (mergeStrategy) {
            case MERGE_FROM_AND_GET: {
                return (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> MergeAndGet::mergeFromAndGet;
            }
            case SELECT_NEWER_AND_GET: {
                return (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> MergeAndGet::selectNewerAndGet;
            }
        }
        throw new RuntimeException("Unsupported merge strategy: " + String.valueOf((Object)mergeStrategy));
    }

    private static <G extends Oaf, A extends Oaf> G mergeFromAndGet(G x, A y) {
        return (G)MergeUtils.merge(x, y, (boolean)true);
    }

    private static <G extends Oaf, A extends Oaf> G selectNewerAndGet(G x, A y) {
        if (x.getClass().equals(y.getClass()) && x.getLastupdatetimestamp() > y.getLastupdatetimestamp()) {
            return x;
        }
        if (x.getClass().equals(y.getClass()) && x.getLastupdatetimestamp() < y.getLastupdatetimestamp()) {
            return (G)y;
        }
        if (ModelSupport.isSubClass(x, y).booleanValue() && x.getLastupdatetimestamp() > y.getLastupdatetimestamp()) {
            return x;
        }
        if (ModelSupport.isSubClass(x, y).booleanValue() && x.getLastupdatetimestamp() < y.getLastupdatetimestamp()) {
            throw new RuntimeException(String.format("SELECT_NEWER_AND_GET cannot return right type when it is not the same as left type: %s, %s", x.getClass().getCanonicalName(), y.getClass().getCanonicalName()));
        }
        throw new RuntimeException(String.format("SELECT_NEWER_AND_GET cannot be used when left is not subtype of right: %s, %s", x.getClass().getCanonicalName(), y.getClass().getCanonicalName()));
    }

    public static enum Strategy {
        MERGE_FROM_AND_GET,
        SELECT_NEWER_AND_GET;

    }
}

