/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.promote;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import eu.dnetlib.dhp.actionmanager.promote.MergeAndGet;
import eu.dnetlib.dhp.actionmanager.promote.PromoteAction;
import eu.dnetlib.dhp.actionmanager.promote.PromoteActionPayloadForGraphTableJob;
import eu.dnetlib.dhp.actionmanager.promote.PromoteActionPayloadFunctions;
import eu.dnetlib.dhp.common.FunctionalInterfaceSupport;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromoteResultWithMeasuresTest {
    private static final Logger log = LoggerFactory.getLogger(PromoteResultWithMeasuresTest.class);
    private static SparkSession spark;
    private static Path tempDir;
    public static final ObjectMapper OBJECT_MAPPER;

    @BeforeAll
    public static void beforeAll() throws IOException {
        tempDir = Files.createTempDirectory(PromoteResultWithMeasuresTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)tempDir);
        SparkConf conf = new SparkConf();
        conf.setMaster("local[*]");
        conf.setAppName(PromoteResultWithMeasuresTest.class.getSimpleName());
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", tempDir.toString());
        conf.set("hive.metastore.warehouse.dir", tempDir.resolve("warehouse").toString());
        spark = SparkSession.builder().config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        spark.stop();
        FileUtils.deleteDirectory((File)tempDir.toFile());
    }

    @Test
    void testPromoteResultWithMeasures_job() throws Exception {
        String inputGraphTablePath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/promote/measures/graph").getPath();
        String inputActionPayloadPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/promote/measures/actionPayloads").getPath();
        String actionPayloadsPath = tempDir.resolve("actionPayloads").toString();
        spark.read().text(inputActionPayloadPath).withColumn("payload", functions.col((String)"value")).select("payload", new String[0]).write().parquet(actionPayloadsPath);
        Path outputGraphTablePath = tempDir.resolve("outputGraphTablePath");
        PromoteActionPayloadForGraphTableJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--graphTableClassName", Publication.class.getCanonicalName(), "--inputGraphTablePath", inputGraphTablePath, "--inputActionPayloadPath", actionPayloadsPath, "--actionPayloadClassName", Result.class.getCanonicalName(), "--outputGraphTablePath", outputGraphTablePath.toString(), "--mergeAndGetStrategy", MergeAndGet.Strategy.MERGE_FROM_AND_GET.toString(), "--promoteActionStrategy", PromoteAction.Strategy.ENRICH.toString(), "--shouldGroupById", "true"});
        Assertions.assertFalse((boolean)PromoteResultWithMeasuresTest.isDirEmpty(outputGraphTablePath));
        Encoder pubEncoder = Encoders.bean(Publication.class);
        List results = spark.read().schema(pubEncoder.schema()).json(outputGraphTablePath.toString()).as(pubEncoder).collectAsList();
        PromoteResultWithMeasuresTest.verify(results);
    }

    @Test
    void testPromoteResultWithMeasures_internal() throws JsonProcessingException {
        Dataset rowDS = spark.read().schema(Encoders.bean(Publication.class).schema()).json("src/test/resources/eu/dnetlib/dhp/actionmanager/promote/measures/graph").as(Encoders.bean(Publication.class));
        Dataset actionPayloadDS = spark.read().schema(Encoders.bean(Result.class).schema()).json("src/test/resources/eu/dnetlib/dhp/actionmanager/promote/measures/actionPayloads").as(Encoders.bean(Result.class));
        MergeAndGet.Strategy mergeFromAndGet = MergeAndGet.Strategy.MERGE_FROM_AND_GET;
        PromoteAction.Strategy enrich = PromoteAction.Strategy.ENRICH;
        FunctionalInterfaceSupport.SerializableSupplier & Serializable rowIdFn = ModelSupport::idFn;
        FunctionalInterfaceSupport.SerializableSupplier mergeAndGetFn = MergeAndGet.functionFor((MergeAndGet.Strategy)mergeFromAndGet);
        FunctionalInterfaceSupport.SerializableSupplier & Serializable zeroFn = (FunctionalInterfaceSupport.SerializableSupplier & Serializable)() -> (Publication)Publication.class.cast(new Publication());
        FunctionalInterfaceSupport.SerializableSupplier & Serializable isNotZeroFn = PromoteResultWithMeasuresTest::isNotZeroFnUsingIdOrSourceAndTarget;
        Dataset joinedResults = PromoteActionPayloadFunctions.joinGraphTableWithActionPayloadAndMerge((Dataset)rowDS, (Dataset)actionPayloadDS, (FunctionalInterfaceSupport.SerializableSupplier)rowIdFn, ModelSupport::idFn, (FunctionalInterfaceSupport.SerializableSupplier)mergeAndGetFn, (PromoteAction.Strategy)PromoteAction.Strategy.ENRICH, Publication.class, Result.class);
        FunctionalInterfaceSupport.SerializableSupplier mergeRowsAndGetFn = MergeAndGet.functionFor((MergeAndGet.Strategy)mergeFromAndGet);
        Dataset mergedResults = PromoteActionPayloadFunctions.groupGraphTableByIdAndMerge((Dataset)joinedResults, (FunctionalInterfaceSupport.SerializableSupplier)rowIdFn, (FunctionalInterfaceSupport.SerializableSupplier)mergeRowsAndGetFn, (FunctionalInterfaceSupport.SerializableSupplier)zeroFn, (FunctionalInterfaceSupport.SerializableSupplier)isNotZeroFn, Publication.class);
        PromoteResultWithMeasuresTest.verify(mergedResults.collectAsList());
    }

    private static void verify(List<Publication> results) throws JsonProcessingException {
        Assertions.assertNotNull(results);
        Assertions.assertEquals((int)1, (int)results.size());
        Result r = (Result)results.get(0);
        log.info(OBJECT_MAPPER.writeValueAsString((Object)r));
        Assertions.assertNotNull((Object)r.getMeasures());
        Assertions.assertFalse((boolean)r.getMeasures().isEmpty());
        Assertions.assertTrue((boolean)r.getMeasures().stream().map(Measure::getId).collect(Collectors.toCollection(HashSet::new)).containsAll(Lists.newArrayList((Object[])new String[]{"downloads", "views", "influence", "popularity", "influence_alt", "popularity_alt", "impulse"})));
    }

    private static <T extends Oaf> Function<T, Boolean> isNotZeroFnUsingIdOrSourceAndTarget() {
        return t -> {
            if (ModelSupport.isSubClass((Oaf)t, Relation.class).booleanValue()) {
                Relation rel = (Relation)t;
                return StringUtils.isNotBlank((CharSequence)rel.getSource()) && StringUtils.isNotBlank((CharSequence)rel.getTarget());
            }
            return StringUtils.isNotBlank((CharSequence)((OafEntity)t).getId());
        };
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

