/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.migration.AbstractMongoExecutor;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;

public class OdfMigrationExecutor
extends AbstractMongoExecutor {
    private static final Log log = LogFactory.getLog(OdfMigrationExecutor.class);

    public OdfMigrationExecutor(String hdfsPath, String hdfsNameNode, String hdfsUser, String mongoBaseUrl, String mongoDb, String dbUrl, String dbUser, String dbPassword) throws Exception {
        super(hdfsPath, hdfsNameNode, hdfsUser, mongoBaseUrl, mongoDb, dbUrl, dbUser, dbPassword);
    }

    @Override
    protected void registerNamespaces(Map<String, String> nsContext) {
        super.registerNamespaces(nsContext);
        nsContext.put("dc", "http://datacite.org/schema/kernel-3");
    }

    @Override
    protected List<StructuredProperty> prepareTitles(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:title", MAIN_TITLE_QUALIFIER, info);
    }

    @Override
    protected List<Author> prepareAuthors(Document doc, DataInfo info) {
        ArrayList<Author> res = new ArrayList<Author>();
        int pos = 1;
        for (Object o : doc.selectNodes("//dc:creator")) {
            Node n = (Node)o;
            Author author = new Author();
            author.setFullname(n.valueOf("./dc:creatorName"));
            author.setName(n.valueOf("./dc:givenName"));
            author.setSurname(n.valueOf("./dc:familyName"));
            author.setAffiliation(this.prepareListFields((Node)doc, "./dc:affiliation", info));
            author.setPid(this.preparePids(doc, info));
            author.setRank(Integer.valueOf(pos++));
            res.add(author);
        }
        return res;
    }

    private List<StructuredProperty> preparePids(Document doc, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : doc.selectNodes("./dc:nameIdentifier")) {
            res.add(OdfMigrationExecutor.structuredProperty(((Node)o).getText(), this.prepareQualifier((Node)o, "./@nameIdentifierScheme", "dnet:pid_types", "dnet:pid_types"), info));
        }
        return res;
    }

    @Override
    protected List<Instance> prepareInstances(Document doc, DataInfo info, KeyValue collectedfrom, KeyValue hostedby) {
        ArrayList<Instance> res = new ArrayList<Instance>();
        for (Object o : doc.selectNodes("//dc:alternateIdentifier[@alternateIdentifierType='URL']")) {
            Instance instance = new Instance();
            instance.setUrl(Arrays.asList(((Node)o).getText().trim()));
            instance.setInstancetype(this.prepareQualifier((Node)doc, "//dr:CobjCategory", "dnet:publication_resource", "dnet:publication_resource"));
            instance.setCollectedfrom(collectedfrom);
            instance.setHostedby(hostedby);
            instance.setDateofacceptance(OdfMigrationExecutor.field(doc.valueOf("//oaf:dateAccepted"), info));
            instance.setDistributionlocation(doc.valueOf("//oaf:distributionlocation"));
            instance.setAccessright(this.prepareQualifier((Node)doc, "//oaf:accessrights", "dnet:access_modes", "dnet:access_modes"));
            instance.setLicense(OdfMigrationExecutor.field(doc.valueOf("//oaf:license"), info));
            instance.setRefereed(OdfMigrationExecutor.field(doc.valueOf("//oaf:refereed"), info));
            instance.setProcessingchargeamount(OdfMigrationExecutor.field(doc.valueOf("//oaf:processingchargeamount"), info));
            instance.setProcessingchargecurrency(OdfMigrationExecutor.field(doc.valueOf("//oaf:processingchargeamount/@currency"), info));
            res.add(instance);
        }
        return res;
    }

    @Override
    protected List<Field<String>> prepareSources(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<StructuredProperty> prepareRelevantDates(Document doc, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : doc.selectNodes("//dc:date")) {
            String dateType = ((Node)o).valueOf("@dateType");
            if (!StringUtils.isBlank((CharSequence)dateType) || dateType.equalsIgnoreCase("Accepted") || dateType.equalsIgnoreCase("Issued") || dateType.equalsIgnoreCase("Updated") || dateType.equalsIgnoreCase("Available")) continue;
            res.add(OdfMigrationExecutor.structuredProperty(((Node)o).getText(), "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date", info));
        }
        return res;
    }

    @Override
    protected List<Field<String>> prepareCoverages(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareContributors(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:contributorName", info);
    }

    @Override
    protected List<Field<String>> prepareFormats(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:format", info);
    }

    @Override
    protected Field<String> preparePublisher(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:publisher", info);
    }

    @Override
    protected List<Field<String>> prepareDescriptions(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:description[@descriptionType='Abstract']", info);
    }

    @Override
    protected List<StructuredProperty> prepareSubjects(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:subject", info);
    }

    @Override
    protected Qualifier prepareLanguages(Document doc) {
        return this.prepareQualifier((Node)doc, "//dc:language", "dnet:languages", "dnet:languages");
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductTools(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactGroups(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:contributor[@contributorType='ContactGroup']/dc:contributorName", info);
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactPersons(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:contributor[@contributorType='ContactPerson']/dc:contributorName", info);
    }

    @Override
    protected Qualifier prepareSoftwareProgrammingLanguage(Document doc, DataInfo info) {
        return this.prepareQualifier((Node)doc, "//dc:format", "dnet:programming_languages", "dnet:programming_languages");
    }

    @Override
    protected Field<String> prepareSoftwareCodeRepositoryUrl(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareSoftwareLicenses(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected List<Field<String>> prepareSoftwareDocumentationUrls(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:relatedIdentifier[@relatedIdentifierType='URL' and @relationType='IsDocumentedBy']", info);
    }

    @Override
    protected List<GeoLocation> prepareDatasetGeoLocations(Document doc, DataInfo info) {
        ArrayList<GeoLocation> res = new ArrayList<GeoLocation>();
        for (Object o : doc.selectNodes("//dc:geoLocation")) {
            GeoLocation loc = new GeoLocation();
            loc.setBox(((Node)o).valueOf("./dc:geoLocationBox"));
            loc.setPlace(((Node)o).valueOf("./dc:geoLocationPlace"));
            loc.setPoint(((Node)o).valueOf("./dc:geoLocationPoint"));
            res.add(loc);
        }
        return res;
    }

    @Override
    protected Field<String> prepareDatasetMetadataVersionNumber(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetLastMetadataUpdate(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:date[@dateType='Updated']", info);
    }

    @Override
    protected Field<String> prepareDatasetVersion(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:version", info);
    }

    @Override
    protected Field<String> prepareDatasetSize(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:size", info);
    }

    @Override
    protected Field<String> prepareDatasetDevice(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetStorageDate(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:date[@dateType='Issued']", info);
    }

    @Override
    protected List<Oaf> addOtherResultRels(Document doc, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        String docId = OdfMigrationExecutor.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"));
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        for (Object o : doc.selectNodes("//*[local-name() = 'resource']//*[local-name()='relatedIdentifier' and ./@relatedIdentifierType='OPENAIRE']")) {
            String otherId = OdfMigrationExecutor.createOpenaireId(50, ((Node)o).getText());
            String type = ((Node)o).valueOf("@relationType");
            if (type.equals("IsSupplementTo")) {
                res.add((Oaf)this.prepareOtherResultRel(collectedFrom, info, lastUpdateTimestamp, docId, otherId, "supplement", "isSupplementTo"));
                res.add((Oaf)this.prepareOtherResultRel(collectedFrom, info, lastUpdateTimestamp, otherId, docId, "supplement", "isSupplementedBy"));
                continue;
            }
            if (!type.equals("IsPartOf")) continue;
            res.add((Oaf)this.prepareOtherResultRel(collectedFrom, info, lastUpdateTimestamp, docId, otherId, "part", "IsPartOf"));
            res.add((Oaf)this.prepareOtherResultRel(collectedFrom, info, lastUpdateTimestamp, otherId, docId, "part", "HasParts"));
        }
        return res;
    }

    private Relation prepareOtherResultRel(KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp, String source, String target, String subRelType, String relClass) {
        Relation r = new Relation();
        r.setRelType("resultResult");
        r.setSubRelType(subRelType);
        r.setRelClass(relClass);
        r.setSource(source);
        r.setTarget(target);
        r.setCollectedFrom(Arrays.asList(collectedFrom));
        r.setDataInfo(info);
        r.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
        return r;
    }

    @Override
    protected Qualifier prepareResourceType(Document doc, DataInfo info) {
        return this.prepareQualifier((Node)doc, "//*[local-name() = 'resource']//*[local-name() = 'resourceType']", "dnet:dataCite_resource", "dnet:dataCite_resource");
    }
}

