/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OriginDescription;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.codehaus.jackson.map.ObjectMapper;

public class AbstractMigrationExecutor
implements Closeable {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Text key = new Text();
    private final Text value = new Text();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SequenceFile.Writer writer;
    private static final Log log = LogFactory.getLog(AbstractMigrationExecutor.class);

    public AbstractMigrationExecutor(String hdfsPath, String hdfsNameNode, String hdfsUser) throws Exception {
        log.info((Object)String.format("Creating SequenceFile Writer, hdfsPath=%s, nameNode=%s, user=%s", hdfsPath, hdfsNameNode, hdfsUser));
        this.writer = SequenceFile.createWriter((Configuration)this.getConf(hdfsNameNode, hdfsUser), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(hdfsPath)), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
    }

    private Configuration getConf(String hdfsNameNode, String hdfsUser) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        System.setProperty("HADOOP_USER_NAME", hdfsUser);
        System.setProperty("hadoop.home.dir", "/");
        FileSystem.get((URI)URI.create(hdfsNameNode), (Configuration)conf);
        return conf;
    }

    protected void emitOaf(Oaf oaf) {
        try {
            this.key.set(this.counter.getAndIncrement() + ":" + oaf.getClass().getSimpleName().toLowerCase());
            this.value.set(this.objectMapper.writeValueAsString((Object)oaf));
            this.writer.append((Writable)this.key, (Writable)this.value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.hflush();
        this.writer.close();
    }

    public static KeyValue keyValue(String k, String v) {
        KeyValue kv = new KeyValue();
        kv.setKey(k);
        kv.setValue(v);
        return kv;
    }

    public static List<KeyValue> listKeyValues(String ... s) {
        if (s.length % 2 > 0) {
            throw new RuntimeException("Invalid number of parameters (k,v,k,v,....)");
        }
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        for (int i = 0; i < s.length; i += 2) {
            list.add(AbstractMigrationExecutor.keyValue(s[i], s[i + 1]));
        }
        return list;
    }

    public static <T> Field<T> field(T value, DataInfo info) {
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        Field field = new Field();
        field.setValue(value);
        field.setDataInfo(info);
        return field;
    }

    public static List<Field<String>> listFields(DataInfo info, String ... values) {
        return Arrays.stream(values).map(v -> AbstractMigrationExecutor.field(v, info)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<Field<String>> listFields(DataInfo info, List<String> values) {
        return values.stream().map(v -> AbstractMigrationExecutor.field(v, info)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Qualifier qualifier(String classid, String classname, String schemeid, String schemename) {
        Qualifier q = new Qualifier();
        q.setClassid(classid);
        q.setClassname(classname);
        q.setSchemeid(schemeid);
        q.setSchemename(schemename);
        return q;
    }

    public static StructuredProperty structuredProperty(String value, String classid, String classname, String schemeid, String schemename, DataInfo dataInfo) {
        return AbstractMigrationExecutor.structuredProperty(value, AbstractMigrationExecutor.qualifier(classid, classname, schemeid, schemename), dataInfo);
    }

    public static StructuredProperty structuredProperty(String value, Qualifier qualifier, DataInfo dataInfo) {
        if (value == null) {
            return null;
        }
        StructuredProperty sp = new StructuredProperty();
        sp.setValue(value);
        sp.setQualifier(qualifier);
        sp.setDataInfo(dataInfo);
        return sp;
    }

    public static ExtraInfo extraInfo(String name, String value, String typology, String provenance, String trust) {
        ExtraInfo info = new ExtraInfo();
        info.setName(name);
        info.setValue(value);
        info.setTypology(typology);
        info.setProvenance(provenance);
        info.setTrust(trust);
        return info;
    }

    public static OAIProvenance oaiIProvenance(String identifier, String baseURL, String metadataNamespace, Boolean altered, String datestamp, String harvestDate) {
        OriginDescription desc = new OriginDescription();
        desc.setIdentifier(identifier);
        desc.setBaseURL(baseURL);
        desc.setMetadataNamespace(metadataNamespace);
        desc.setAltered(altered);
        desc.setDatestamp(datestamp);
        desc.setHarvestDate(harvestDate);
        OAIProvenance p = new OAIProvenance();
        p.setOriginDescription(desc);
        return p;
    }

    public static Journal journal(String name, String issnPrinted, String issnOnline, String issnLinking, String ep, String iss, String sp, String vol, String edition, String conferenceplace, String conferencedate, DataInfo dataInfo) {
        if (StringUtils.isNotBlank((CharSequence)name) || StringUtils.isNotBlank((CharSequence)issnPrinted) || StringUtils.isNotBlank((CharSequence)issnOnline) || StringUtils.isNotBlank((CharSequence)issnLinking)) {
            Journal j = new Journal();
            j.setName(name);
            j.setIssnPrinted(issnPrinted);
            j.setIssnOnline(issnOnline);
            j.setIssnLinking(issnLinking);
            j.setEp(ep);
            j.setIss(iss);
            j.setSp(sp);
            j.setVol(vol);
            j.setEdition(edition);
            j.setConferenceplace(conferenceplace);
            j.setConferencedate(conferencedate);
            j.setDataInfo(dataInfo);
            return j;
        }
        return null;
    }

    public static DataInfo dataInfo(Boolean deletedbyinference, String inferenceprovenance, Boolean inferred, Boolean invisible, Qualifier provenanceaction, String trust) {
        DataInfo d = new DataInfo();
        d.setDeletedbyinference(deletedbyinference);
        d.setInferenceprovenance(inferenceprovenance);
        d.setInferred(inferred);
        d.setInvisible(invisible);
        d.setProvenanceaction(provenanceaction);
        d.setTrust(trust);
        return d;
    }

    public static String createOpenaireId(int prefix, String originalId) {
        String nsPrefix = StringUtils.substringBefore((String)originalId, (String)"::");
        String rest = StringUtils.substringAfter((String)originalId, (String)"::");
        return String.format("%s|%s::%s", prefix, nsPrefix, DHPUtils.md5((String)rest));
    }

    public static String asString(Object o) {
        return o == null ? "" : o.toString();
    }
}

