/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.migration.MigrateMongoMdstoresApplication;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class ExtractEntitiesFromHDFSJob {
    private static List<String> folderNames = Arrays.asList("db_entities", "oaf_entities", "odf_entities");

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/migration/extract_entities_from_hdfs_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(ExtractEntitiesFromHDFSJob.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        String sourcePath = parser.get("sourcePath");
        String targetPath = parser.get("graphRawPath");
        String entity = parser.get("entity");
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD inputRdd = sc.emptyRDD();
        folderNames.forEach(p -> inputRdd.union(sc.sequenceFile(sourcePath + "/" + p, Text.class, Text.class).map((Function & Serializable)k -> new Tuple2((Object)((Text)k._1()).toString(), (Object)((Text)k._2()).toString())).filter((Function & Serializable)k -> ExtractEntitiesFromHDFSJob.isEntityType((String)k._1(), entity)).map(Tuple2::_2)));
        inputRdd.saveAsTextFile(targetPath + "/" + entity);
    }

    private static boolean isEntityType(String item, String entity) {
        return StringUtils.substringAfter((String)item, (String)":").equalsIgnoreCase(entity);
    }
}

