/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation;

import eu.dnetlib.dhp.model.mdstore.MetadataRecord;
import eu.dnetlib.dhp.transformation.functions.Cleaner;
import eu.dnetlib.dhp.transformation.vocabulary.Vocabulary;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.util.LongAccumulator;

public class TransformFunction
implements MapFunction<MetadataRecord, MetadataRecord> {
    private final LongAccumulator totalItems;
    private final LongAccumulator errorItems;
    private final LongAccumulator transformedItems;
    private final String transformationRule;
    private final Cleaner cleanFunction;
    private final long dateOfTransformation;

    public TransformFunction(LongAccumulator totalItems, LongAccumulator errorItems, LongAccumulator transformedItems, String transformationRule, long dateOfTransformation, Map<String, Vocabulary> vocabularies) throws Exception {
        this.totalItems = totalItems;
        this.errorItems = errorItems;
        this.transformedItems = transformedItems;
        this.transformationRule = transformationRule;
        this.dateOfTransformation = dateOfTransformation;
        this.cleanFunction = new Cleaner(vocabularies);
    }

    public MetadataRecord call(MetadataRecord value) {
        this.totalItems.add(1L);
        try {
            Processor processor = new Processor(false);
            processor.registerExtensionFunction((ExtensionFunction)this.cleanFunction);
            XsltCompiler comp = processor.newXsltCompiler();
            XsltExecutable xslt = comp.compile((Source)new StreamSource(new ByteArrayInputStream(this.transformationRule.getBytes())));
            XdmNode source = processor.newDocumentBuilder().build((Source)new StreamSource(new ByteArrayInputStream(value.getBody().getBytes())));
            XsltTransformer trans = xslt.load();
            trans.setInitialContextNode(source);
            StringWriter output = new StringWriter();
            Serializer out = processor.newSerializer((Writer)output);
            out.setOutputProperty(Serializer.Property.METHOD, "xml");
            out.setOutputProperty(Serializer.Property.INDENT, "yes");
            trans.setDestination((Destination)out);
            trans.transform();
            String xml = output.toString();
            value.setBody(xml);
            value.setDateOfTransformation(this.dateOfTransformation);
            this.transformedItems.add(1L);
            return value;
        }
        catch (Throwable e) {
            this.errorItems.add(1L);
            return null;
        }
    }
}

