/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.oai;

import eu.dnetlib.dhp.collection.worker.DnetCollectorException;
import eu.dnetlib.dhp.collection.worker.utils.HttpConnector;
import eu.dnetlib.dhp.collection.worker.utils.XmlCleaner;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class OaiIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(OaiIterator.class);
    private final Queue<String> queue = new PriorityBlockingQueue<String>();
    private final SAXReader reader = new SAXReader();
    private final String baseUrl;
    private final String set;
    private final String mdFormat;
    private final String fromDate;
    private final String untilDate;
    private String token;
    private boolean started;
    private final HttpConnector httpConnector;

    public OaiIterator(String baseUrl, String mdFormat, String set, String fromDate, String untilDate, HttpConnector httpConnector) {
        this.baseUrl = baseUrl;
        this.mdFormat = mdFormat;
        this.set = set;
        this.fromDate = fromDate;
        this.untilDate = untilDate;
        this.started = false;
        this.httpConnector = httpConnector;
    }

    private void verifyStarted() {
        if (!this.started) {
            this.started = true;
            try {
                this.token = this.firstPage();
            }
            catch (DnetCollectorException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            String res = this.queue.poll();
            while (this.queue.isEmpty() && this.token != null && !this.token.isEmpty()) {
                try {
                    this.token = this.otherPages(this.token);
                }
                catch (DnetCollectorException e) {
                    throw new RuntimeException(e);
                }
            }
            return res;
        }
    }

    @Override
    public void remove() {
    }

    private String firstPage() throws DnetCollectorException {
        try {
            String url = this.baseUrl + "?verb=ListRecords&metadataPrefix=" + URLEncoder.encode(this.mdFormat, "UTF-8");
            if (this.set != null && !this.set.isEmpty()) {
                url = url + "&set=" + URLEncoder.encode(this.set, "UTF-8");
            }
            if (this.fromDate != null && this.fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
                url = url + "&from=" + URLEncoder.encode(this.fromDate, "UTF-8");
            }
            if (this.untilDate != null && this.untilDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
                url = url + "&until=" + URLEncoder.encode(this.untilDate, "UTF-8");
            }
            log.info((Object)("Start harvesting using url: " + url));
            return this.downloadPage(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new DnetCollectorException(e);
        }
    }

    private String extractResumptionToken(String xml) {
        String s = StringUtils.substringAfter((String)xml, (String)"<resumptionToken");
        if (s == null) {
            return null;
        }
        String result = StringUtils.substringBetween((String)s, (String)">", (String)"</");
        if (result == null) {
            return null;
        }
        return result.trim();
    }

    private String otherPages(String resumptionToken) throws DnetCollectorException {
        try {
            return this.downloadPage(this.baseUrl + "?verb=ListRecords&resumptionToken=" + URLEncoder.encode(resumptionToken, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DnetCollectorException(e);
        }
    }

    private String downloadPage(String url) throws DnetCollectorException {
        Document doc;
        String xml = this.httpConnector.getInputSource(url);
        try {
            doc = this.reader.read((Reader)new StringReader(xml));
        }
        catch (DocumentException e) {
            log.warn((Object)("Error parsing xml, I try to clean it: " + xml), (Throwable)e);
            String cleaned = XmlCleaner.cleanAllEntities(xml);
            try {
                doc = this.reader.read((Reader)new StringReader(cleaned));
            }
            catch (DocumentException e1) {
                String resumptionToken = this.extractResumptionToken(xml);
                if (resumptionToken == null) {
                    throw new DnetCollectorException("Error parsing cleaned document:" + cleaned, e1);
                }
                return resumptionToken;
            }
        }
        Node errorNode = doc.selectSingleNode("/*[local-name()='OAI-PMH']/*[local-name()='error']");
        if (errorNode != null) {
            String code = errorNode.valueOf("@code");
            if ("noRecordsMatch".equalsIgnoreCase(code.trim())) {
                log.warn((Object)("noRecordsMatch for oai call: " + url));
                return null;
            }
            throw new DnetCollectorException(code + " - " + errorNode.getText());
        }
        for (Object o : doc.selectNodes("//*[local-name()='ListRecords']/*[local-name()='record']")) {
            this.queue.add(((Node)o).asXML());
        }
        return doc.valueOf("//*[local-name()='resumptionToken']");
    }
}

