/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.migration.AbstractMigrationExecutor;
import eu.dnetlib.dhp.migration.DbClient;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MigrateDbEntitiesApplication
extends AbstractMigrationExecutor
implements Closeable {
    private static final Qualifier ENTITYREGISTRY_PROVENANCE_ACTION = MigrateDbEntitiesApplication.qualifier("sysimport:crosswalk:entityregistry", "sysimport:crosswalk:entityregistry", "dnet:provenance_actions", "dnet:provenance_actions");
    private static final Log log = LogFactory.getLog(MigrateDbEntitiesApplication.class);
    private final DbClient dbClient;
    private final long lastUpdateTimestamp;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateDbEntitiesApplication.class.getResourceAsStream("/eu/dnetlib/dhp/migration/migrate_db_entities_parameters.json")));
        parser.parseArgument(args);
        String dbUrl = parser.get("postgresUrl");
        String dbUser = parser.get("postgresUser");
        String dbPassword = parser.get("postgresPassword");
        String hdfsPath = parser.get("hdfsPath");
        String hdfsNameNode = parser.get("namenode");
        String hdfsUser = parser.get("hdfsUser");
        try (MigrateDbEntitiesApplication smdbe = new MigrateDbEntitiesApplication(hdfsPath, hdfsNameNode, hdfsUser, dbUrl, dbUser, dbPassword);){
            log.info((Object)"Processing datasources...");
            smdbe.execute("queryDatasources.sql", smdbe::processDatasource);
            log.info((Object)"Processing projects...");
            smdbe.execute("queryProjects.sql", smdbe::processProject);
            log.info((Object)"Processing orgs...");
            smdbe.execute("queryOrganizations.sql", smdbe::processOrganization);
            log.info((Object)"Processing relations ds <-> orgs ...");
            smdbe.execute("queryDatasourceOrganization.sql", smdbe::processDatasourceOrganization);
            log.info((Object)"Processing projects <-> orgs ...");
            smdbe.execute("queryProjectOrganization.sql", smdbe::processProjectOrganization);
            log.info((Object)"All done.");
        }
    }

    public MigrateDbEntitiesApplication(String hdfsPath, String hdfsNameNode, String hdfsUser, String dbUrl, String dbUser, String dbPassword) throws Exception {
        super(hdfsPath, hdfsNameNode, hdfsUser);
        this.dbClient = new DbClient(dbUrl, dbUser, dbPassword);
        this.lastUpdateTimestamp = new Date().getTime();
    }

    public void execute(String sqlFile, Consumer<ResultSet> consumer) throws Exception {
        String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/migration/sql/" + sqlFile));
        this.dbClient.processResults(sql, consumer);
    }

    public void processDatasource(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Datasource ds = new Datasource();
            ds.setId(MigrateDbEntitiesApplication.createOpenaireId(10, rs.getString("datasourceid")));
            ds.setOriginalId(Arrays.asList(rs.getString("datasourceid")));
            ds.setCollectedfrom(MigrateDbEntitiesApplication.listKeyValues(rs.getString("collectedfromid"), rs.getString("collectedfromname")));
            ds.setPid(new ArrayList());
            ds.setDateofcollection(MigrateDbEntitiesApplication.asString(rs.getDate("dateofcollection")));
            ds.setDateoftransformation(null);
            ds.setExtraInfo(new ArrayList());
            ds.setOaiprovenance(null);
            ds.setDatasourcetype(this.prepareQualifierSplitting(rs.getString("datasourcetype")));
            ds.setOpenairecompatibility(this.prepareQualifierSplitting(rs.getString("openairecompatibility")));
            ds.setOfficialname(MigrateDbEntitiesApplication.field(rs.getString("officialname"), info));
            ds.setEnglishname(MigrateDbEntitiesApplication.field(rs.getString("englishname"), info));
            ds.setWebsiteurl(MigrateDbEntitiesApplication.field(rs.getString("websiteurl"), info));
            ds.setLogourl(MigrateDbEntitiesApplication.field(rs.getString("logourl"), info));
            ds.setContactemail(MigrateDbEntitiesApplication.field(rs.getString("contactemail"), info));
            ds.setNamespaceprefix(MigrateDbEntitiesApplication.field(rs.getString("namespaceprefix"), info));
            ds.setLatitude(MigrateDbEntitiesApplication.field(Double.toString(rs.getDouble("latitude")), info));
            ds.setLongitude(MigrateDbEntitiesApplication.field(Double.toString(rs.getDouble("longitude")), info));
            ds.setDateofvalidation(MigrateDbEntitiesApplication.field(MigrateDbEntitiesApplication.asString(rs.getDate("dateofvalidation")), info));
            ds.setDescription(MigrateDbEntitiesApplication.field(rs.getString("description"), info));
            ds.setSubjects(this.prepareListOfStructProps(rs.getArray("subjects"), info));
            ds.setOdnumberofitems(MigrateDbEntitiesApplication.field(Double.toString(rs.getInt("odnumberofitems")), info));
            ds.setOdnumberofitemsdate(MigrateDbEntitiesApplication.field(MigrateDbEntitiesApplication.asString(rs.getDate("odnumberofitemsdate")), info));
            ds.setOdpolicies(MigrateDbEntitiesApplication.field(rs.getString("odpolicies"), info));
            ds.setOdlanguages(this.prepareListFields(rs.getArray("odlanguages"), info));
            ds.setOdcontenttypes(this.prepareListFields(rs.getArray("odcontenttypes"), info));
            ds.setAccessinfopackage(this.prepareListFields(rs.getArray("accessinfopackage"), info));
            ds.setReleasestartdate(MigrateDbEntitiesApplication.field(MigrateDbEntitiesApplication.asString(rs.getDate("releasestartdate")), info));
            ds.setReleaseenddate(MigrateDbEntitiesApplication.field(MigrateDbEntitiesApplication.asString(rs.getDate("releaseenddate")), info));
            ds.setMissionstatementurl(MigrateDbEntitiesApplication.field(rs.getString("missionstatementurl"), info));
            ds.setDataprovider(MigrateDbEntitiesApplication.field(rs.getBoolean("dataprovider"), info));
            ds.setServiceprovider(MigrateDbEntitiesApplication.field(rs.getBoolean("serviceprovider"), info));
            ds.setDatabaseaccesstype(MigrateDbEntitiesApplication.field(rs.getString("databaseaccesstype"), info));
            ds.setDatauploadtype(MigrateDbEntitiesApplication.field(rs.getString("datauploadtype"), info));
            ds.setDatabaseaccessrestriction(MigrateDbEntitiesApplication.field(rs.getString("databaseaccessrestriction"), info));
            ds.setDatauploadrestriction(MigrateDbEntitiesApplication.field(rs.getString("datauploadrestriction"), info));
            ds.setVersioning(MigrateDbEntitiesApplication.field(rs.getBoolean("versioning"), info));
            ds.setCitationguidelineurl(MigrateDbEntitiesApplication.field(rs.getString("citationguidelineurl"), info));
            ds.setQualitymanagementkind(MigrateDbEntitiesApplication.field(rs.getString("qualitymanagementkind"), info));
            ds.setPidsystems(MigrateDbEntitiesApplication.field(rs.getString("pidsystems"), info));
            ds.setCertificates(MigrateDbEntitiesApplication.field(rs.getString("certificates"), info));
            ds.setPolicies(new ArrayList());
            ds.setJournal(this.prepareJournal(rs.getString("officialname"), rs.getString("journal"), info));
            ds.setDataInfo(info);
            ds.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)ds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processProject(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Project p = new Project();
            p.setId(MigrateDbEntitiesApplication.createOpenaireId(40, rs.getString("projectid")));
            p.setOriginalId(Arrays.asList(rs.getString("projectid")));
            p.setCollectedfrom(MigrateDbEntitiesApplication.listKeyValues(rs.getString("collectedfromid"), rs.getString("collectedfromname")));
            p.setPid(new ArrayList());
            p.setDateofcollection(MigrateDbEntitiesApplication.asString(rs.getDate("dateofcollection")));
            p.setDateoftransformation(MigrateDbEntitiesApplication.asString(rs.getDate("dateoftransformation")));
            p.setExtraInfo(new ArrayList());
            p.setOaiprovenance(null);
            p.setWebsiteurl(MigrateDbEntitiesApplication.field(rs.getString("websiteurl"), info));
            p.setCode(MigrateDbEntitiesApplication.field(rs.getString("code"), info));
            p.setAcronym(MigrateDbEntitiesApplication.field(rs.getString("acronym"), info));
            p.setTitle(MigrateDbEntitiesApplication.field(rs.getString("title"), info));
            p.setStartdate(MigrateDbEntitiesApplication.field(MigrateDbEntitiesApplication.asString(rs.getDate("startdate")), info));
            p.setEnddate(MigrateDbEntitiesApplication.field(MigrateDbEntitiesApplication.asString(rs.getDate("enddate")), info));
            p.setCallidentifier(MigrateDbEntitiesApplication.field(rs.getString("callidentifier"), info));
            p.setKeywords(MigrateDbEntitiesApplication.field(rs.getString("keywords"), info));
            p.setDuration(MigrateDbEntitiesApplication.field(Integer.toString(rs.getInt("duration")), info));
            p.setEcsc39(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecsc39")), info));
            p.setOamandatepublications(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("oamandatepublications")), info));
            p.setEcarticle29_3(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecarticle29_3")), info));
            p.setSubjects(this.prepareListOfStructProps(rs.getArray("subjects"), info));
            p.setFundingtree(this.prepareListFields(rs.getArray("fundingtree"), info));
            p.setContracttype(this.prepareQualifierSplitting(rs.getString("contracttype")));
            p.setOptional1(MigrateDbEntitiesApplication.field(rs.getString("optional1"), info));
            p.setOptional2(MigrateDbEntitiesApplication.field(rs.getString("optional2"), info));
            p.setJsonextrainfo(MigrateDbEntitiesApplication.field(rs.getString("jsonextrainfo"), info));
            p.setContactfullname(MigrateDbEntitiesApplication.field(rs.getString("contactfullname"), info));
            p.setContactfax(MigrateDbEntitiesApplication.field(rs.getString("contactfax"), info));
            p.setContactphone(MigrateDbEntitiesApplication.field(rs.getString("contactphone"), info));
            p.setContactemail(MigrateDbEntitiesApplication.field(rs.getString("contactemail"), info));
            p.setSummary(MigrateDbEntitiesApplication.field(rs.getString("summary"), info));
            p.setCurrency(MigrateDbEntitiesApplication.field(rs.getString("currency"), info));
            p.setTotalcost(new Float(rs.getDouble("totalcost")));
            p.setFundedamount(new Float(rs.getDouble("fundedamount")));
            p.setDataInfo(info);
            p.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)p);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            Organization o = new Organization();
            o.setId(MigrateDbEntitiesApplication.createOpenaireId(20, rs.getString("organizationid")));
            o.setOriginalId(Arrays.asList(rs.getString("organizationid")));
            o.setCollectedfrom(MigrateDbEntitiesApplication.listKeyValues(rs.getString("collectedfromid"), rs.getString("collectedfromname")));
            o.setPid(new ArrayList());
            o.setDateofcollection(MigrateDbEntitiesApplication.asString(rs.getDate("dateofcollection")));
            o.setDateoftransformation(MigrateDbEntitiesApplication.asString(rs.getDate("dateoftransformation")));
            o.setExtraInfo(new ArrayList());
            o.setOaiprovenance(null);
            o.setLegalshortname(MigrateDbEntitiesApplication.field("legalshortname", info));
            o.setLegalname(MigrateDbEntitiesApplication.field("legalname", info));
            o.setAlternativeNames(new ArrayList());
            o.setWebsiteurl(MigrateDbEntitiesApplication.field("websiteurl", info));
            o.setLogourl(MigrateDbEntitiesApplication.field("logourl", info));
            o.setEclegalbody(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("eclegalbody")), info));
            o.setEclegalperson(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("eclegalperson")), info));
            o.setEcnonprofit(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecnonprofit")), info));
            o.setEcresearchorganization(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecresearchorganization")), info));
            o.setEchighereducation(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("echighereducation")), info));
            o.setEcinternationalorganizationeurinterests(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecinternationalorganizationeurinterests")), info));
            o.setEcinternationalorganization(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecinternationalorganization")), info));
            o.setEcenterprise(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecenterprise")), info));
            o.setEcsmevalidated(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecsmevalidated")), info));
            o.setEcnutscode(MigrateDbEntitiesApplication.field(Boolean.toString(rs.getBoolean("ecnutscode")), info));
            o.setCountry(this.prepareQualifierSplitting(rs.getString("country")));
            o.setDataInfo(info);
            o.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processDatasourceOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId = MigrateDbEntitiesApplication.createOpenaireId(20, rs.getString("organization"));
            String dsId = MigrateDbEntitiesApplication.createOpenaireId(10, rs.getString("datasource"));
            List<KeyValue> collectedFrom = MigrateDbEntitiesApplication.listKeyValues(rs.getString("collectedfromid"), rs.getString("collectedfromname"));
            Relation r1 = new Relation();
            r1.setRelType("datasourceOrganization");
            r1.setSubRelType("provision");
            r1.setRelClass("isProvidedBy");
            r1.setSource(dsId);
            r1.setTarget(orgId);
            r1.setCollectedFrom(collectedFrom);
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)r1);
            Relation r2 = new Relation();
            r2.setRelType("datasourceOrganization");
            r2.setSubRelType("provision");
            r2.setRelClass("provides");
            r2.setSource(orgId);
            r2.setTarget(dsId);
            r2.setCollectedFrom(collectedFrom);
            r2.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void processProjectOrganization(ResultSet rs) {
        try {
            DataInfo info = this.prepareDataInfo(rs);
            String orgId = MigrateDbEntitiesApplication.createOpenaireId(20, rs.getString("resporganization"));
            String projectId = MigrateDbEntitiesApplication.createOpenaireId(40, rs.getString("project"));
            List<KeyValue> collectedFrom = MigrateDbEntitiesApplication.listKeyValues(rs.getString("collectedfromid"), rs.getString("collectedfromname"));
            Relation r1 = new Relation();
            r1.setRelType("projectOrganization");
            r1.setSubRelType("participation");
            r1.setRelClass("isParticipant");
            r1.setSource(projectId);
            r1.setTarget(orgId);
            r1.setCollectedFrom(collectedFrom);
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)r1);
            Relation r2 = new Relation();
            r2.setRelType("projectOrganization");
            r2.setSubRelType("participation");
            r2.setRelClass("hasParticipant");
            r2.setSource(orgId);
            r2.setTarget(projectId);
            r2.setCollectedFrom(collectedFrom);
            r2.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(this.lastUpdateTimestamp));
            this.emitOaf((Oaf)r2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DataInfo prepareDataInfo(ResultSet rs) throws SQLException {
        Boolean deletedbyinference = rs.getBoolean("deletedbyinference");
        String inferenceprovenance = rs.getString("inferenceprovenance");
        Boolean inferred = rs.getBoolean("inferred");
        String trust = rs.getString("trust");
        return MigrateDbEntitiesApplication.dataInfo(deletedbyinference, inferenceprovenance, inferred, false, ENTITYREGISTRY_PROVENANCE_ACTION, trust);
    }

    private Qualifier prepareQualifierSplitting(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] arr = s.split("@@@");
        return arr.length == 4 ? MigrateDbEntitiesApplication.qualifier(arr[0], arr[1], arr[2], arr[3]) : null;
    }

    private List<Field<String>> prepareListFields(Array array, DataInfo info) {
        try {
            return MigrateDbEntitiesApplication.listFields(info, (String[])array.getArray());
        }
        catch (SQLException e) {
            throw new RuntimeException("Invalid SQL array", e);
        }
    }

    private StructuredProperty prepareStructProp(String s, DataInfo dataInfo) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] parts = s.split("###");
        if (parts.length == 2) {
            String value = parts[0];
            String[] arr = parts[1].split("@@@");
            if (arr.length == 4) {
                return MigrateDbEntitiesApplication.structuredProperty(value, arr[0], arr[1], arr[2], arr[3], dataInfo);
            }
        }
        return null;
    }

    private List<StructuredProperty> prepareListOfStructProps(Array array, DataInfo dataInfo) throws SQLException {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        if (array != null) {
            for (String s : (String[])array.getArray()) {
                StructuredProperty sp = this.prepareStructProp(s, dataInfo);
                if (sp == null) continue;
                res.add(sp);
            }
        }
        return res;
    }

    private Journal prepareJournal(String name, String sj, DataInfo info) {
        String[] arr;
        if (StringUtils.isNotBlank((CharSequence)sj) && (arr = sj.split("@@@")).length == 3) {
            String lissn;
            String issn = StringUtils.isNotBlank((CharSequence)arr[0]) ? arr[0] : null;
            String eissn = StringUtils.isNotBlank((CharSequence)arr[1]) ? arr[1] : null;
            String string = lissn = StringUtils.isNotBlank((CharSequence)arr[2]) ? arr[2] : null;
            if (issn != null || eissn != null || lissn != null) {
                return MigrateDbEntitiesApplication.journal(name, issn, eissn, eissn, null, null, null, null, null, null, null, info);
            }
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.dbClient.close();
    }
}

