/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.model.mdstore.MetadataRecord;
import eu.dnetlib.dhp.transformation.TransformFunction;
import eu.dnetlib.dhp.transformation.vocabulary.Vocabulary;
import eu.dnetlib.dhp.transformation.vocabulary.VocabularyHelper;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.message.Message;
import eu.dnetlib.message.MessageManager;
import eu.dnetlib.message.MessageType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TransformSparkJobNode {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)TransformSparkJobNode.class.getResourceAsStream("/eu/dnetlib/dhp/transformation/transformation_input_parameters.json")));
        parser.parseArgument(args);
        String inputPath = parser.get("input");
        String outputPath = parser.get("output");
        String workflowId = parser.get("workflowId");
        String trasformationRule = TransformSparkJobNode.extractXSLTFromTR(Objects.requireNonNull(DHPUtils.decompressString((String)parser.get("transformationRule"))));
        String master = parser.get("master");
        String rabbitUser = parser.get("rabbitUser");
        String rabbitPassword = parser.get("rabbitPassword");
        String rabbitHost = parser.get("rabbitHost");
        String rabbitReportQueue = parser.get("rabbitReportQueue");
        long dateOfCollection = new Long(parser.get("dateOfCollection"));
        boolean test = parser.get("isTest") == null ? false : Boolean.valueOf(parser.get("isTest"));
        SparkSession spark = SparkSession.builder().appName("TransformStoreSparkJob").master(master).getOrCreate();
        Encoder encoder = Encoders.bean(MetadataRecord.class);
        Dataset mdstoreInput = spark.read().format("parquet").load(inputPath).as(encoder);
        LongAccumulator totalItems = spark.sparkContext().longAccumulator("TotalItems");
        LongAccumulator errorItems = spark.sparkContext().longAccumulator("errorItems");
        LongAccumulator transformedItems = spark.sparkContext().longAccumulator("transformedItems");
        HashMap<String, Vocabulary> vocabularies = new HashMap<String, Vocabulary>();
        vocabularies.put("dnet:languages", VocabularyHelper.getVocabularyFromAPI("dnet:languages"));
        TransformFunction transformFunction = new TransformFunction(totalItems, errorItems, transformedItems, trasformationRule, dateOfCollection, vocabularies);
        mdstoreInput.map((MapFunction)transformFunction, encoder).write().format("parquet").save(outputPath);
        if (rabbitHost != null) {
            System.out.println("SEND FINAL REPORT");
            HashMap<String, String> reportMap = new HashMap<String, String>();
            reportMap.put("inputItem", "" + totalItems.value());
            reportMap.put("invalidRecords", "" + errorItems.value());
            reportMap.put("mdStoreSize", "" + transformedItems.value());
            System.out.println(new Message(workflowId, "Transform", MessageType.REPORT, reportMap));
            if (!test) {
                MessageManager manager = new MessageManager(rabbitHost, rabbitUser, rabbitPassword, false, false, null);
                manager.sendMessage(new Message(workflowId, "Transform", MessageType.REPORT, reportMap), rabbitReportQueue, true, false);
                manager.close();
            }
        }
    }

    private static String extractXSLTFromTR(String tr) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(tr.getBytes()));
        Node node = document.selectSingleNode("//CODE/*[local-name()='stylesheet']");
        return node.asXML();
    }
}

