/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.worker.utils;

import eu.dnetlib.dhp.collection.worker.DnetCollectorException;
import eu.dnetlib.dhp.collection.worker.utils.CollectorPluginErrorLogList;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnector {
    private static final Log log = LogFactory.getLog(HttpConnector.class);
    private int maxNumberOfRetry = 6;
    private int defaultDelay = 120;
    private int readTimeOut = 120;
    private String responseType = null;
    private final String userAgent = "Mozilla/5.0 (compatible; OAI; +http://www.openaire.eu)";

    public HttpConnector() {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }

    public String getInputSource(String requestUrl) throws DnetCollectorException {
        return this.attemptDownlaodAsString(requestUrl, 1, new CollectorPluginErrorLogList());
    }

    public InputStream getInputSourceAsStream(String requestUrl) throws DnetCollectorException {
        return this.attemptDownload(requestUrl, 1, new CollectorPluginErrorLogList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String attemptDownlaodAsString(String requestUrl, int retryNumber, CollectorPluginErrorLogList errorList) throws DnetCollectorException {
        String string;
        InputStream s = this.attemptDownload(requestUrl, 1, new CollectorPluginErrorLogList());
        try {
            string = IOUtils.toString((InputStream)s);
        }
        catch (IOException e) {
            String string2;
            try {
                log.error((Object)("error while retrieving from http-connection occured: " + requestUrl), (Throwable)e);
                Thread.sleep(this.defaultDelay * 1000);
                errorList.add(e.getMessage());
                string2 = this.attemptDownlaodAsString(requestUrl, retryNumber + 1, errorList);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)s);
                    throw throwable;
                }
                catch (InterruptedException e2) {
                    throw new DnetCollectorException(e2);
                }
            }
            IOUtils.closeQuietly((InputStream)s);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)s);
        return string;
    }

    private InputStream attemptDownload(String requestUrl, int retryNumber, CollectorPluginErrorLogList errorList) throws DnetCollectorException {
        if (retryNumber > this.maxNumberOfRetry) {
            throw new DnetCollectorException("Max number of retries exceeded. Cause: \n " + errorList);
        }
        log.debug((Object)("Downloading " + requestUrl + " - try: " + retryNumber));
        try {
            InputStream input = null;
            try {
                int retryAfter;
                HttpURLConnection urlConn = (HttpURLConnection)new URL(requestUrl).openConnection();
                urlConn.setInstanceFollowRedirects(false);
                urlConn.setReadTimeout(this.readTimeOut * 1000);
                urlConn.addRequestProperty("User-Agent", "Mozilla/5.0 (compatible; OAI; +http://www.openaire.eu)");
                if (log.isDebugEnabled()) {
                    this.logHeaderFields(urlConn);
                }
                if ((retryAfter = this.obtainRetryAfter(urlConn.getHeaderFields())) > 0 && urlConn.getResponseCode() == 503) {
                    log.warn((Object)("waiting and repeating request after " + retryAfter + " sec."));
                    Thread.sleep(retryAfter * 1000);
                    errorList.add("503 Service Unavailable");
                    urlConn.disconnect();
                    return this.attemptDownload(requestUrl, retryNumber + 1, errorList);
                }
                if (urlConn.getResponseCode() == 301 || urlConn.getResponseCode() == 302) {
                    String newUrl = this.obtainNewLocation(urlConn.getHeaderFields());
                    log.debug((Object)("The requested url has been moved to " + newUrl));
                    errorList.add(String.format("%s %s. Moved to: %s", urlConn.getResponseCode(), urlConn.getResponseMessage(), newUrl));
                    urlConn.disconnect();
                    return this.attemptDownload(newUrl, retryNumber + 1, errorList);
                }
                if (urlConn.getResponseCode() != 200) {
                    log.error((Object)String.format("HTTP error: %s %s", urlConn.getResponseCode(), urlConn.getResponseMessage()));
                    Thread.sleep(this.defaultDelay * 1000);
                    errorList.add(String.format("%s %s", urlConn.getResponseCode(), urlConn.getResponseMessage()));
                    urlConn.disconnect();
                    return this.attemptDownload(requestUrl, retryNumber + 1, errorList);
                }
                input = urlConn.getInputStream();
                this.responseType = urlConn.getContentType();
                return input;
            }
            catch (IOException e) {
                log.error((Object)("error while retrieving from http-connection occured: " + requestUrl), (Throwable)e);
                Thread.sleep(this.defaultDelay * 1000);
                errorList.add(e.getMessage());
                return this.attemptDownload(requestUrl, retryNumber + 1, errorList);
            }
        }
        catch (InterruptedException e) {
            throw new DnetCollectorException(e);
        }
    }

    private void logHeaderFields(HttpURLConnection urlConn) throws IOException {
        log.debug((Object)("StatusCode: " + urlConn.getResponseMessage()));
        for (Map.Entry<String, List<String>> e : urlConn.getHeaderFields().entrySet()) {
            if (e.getKey() == null) continue;
            for (String v : e.getValue()) {
                log.debug((Object)("  key: " + e.getKey() + " - value: " + v));
            }
        }
    }

    private int obtainRetryAfter(Map<String, List<String>> headerMap) {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.toLowerCase().equals("retry-after") || headerMap.get(key).size() <= 0 || !NumberUtils.isNumber((String)headerMap.get(key).get(0))) continue;
            return Integer.parseInt(headerMap.get(key).get(0)) + 10;
        }
        return -1;
    }

    private String obtainNewLocation(Map<String, List<String>> headerMap) throws DnetCollectorException {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.toLowerCase().equals("location") || headerMap.get(key).size() <= 0) continue;
            return headerMap.get(key).get(0);
        }
        throw new DnetCollectorException("The requested url has been MOVED, but 'location' param is MISSING");
    }

    public void initTrustManager() {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{tm}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (GeneralSecurityException e) {
            log.fatal((Object)e);
            throw new IllegalStateException(e);
        }
    }

    public int getMaxNumberOfRetry() {
        return this.maxNumberOfRetry;
    }

    public void setMaxNumberOfRetry(int maxNumberOfRetry) {
        this.maxNumberOfRetry = maxNumberOfRetry;
    }

    public int getDefaultDelay() {
        return this.defaultDelay;
    }

    public void setDefaultDelay(int defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getResponseType() {
        return this.responseType;
    }
}

