/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.oai;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.collector.worker.model.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.oai.OaiIteratorFactory;
import eu.dnetlib.dhp.collection.worker.DnetCollectorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class OaiCollectorPlugin
implements CollectorPlugin {
    private static final String FORMAT_PARAM = "format";
    private static final String OAI_SET_PARAM = "set";
    private static final Object OAI_FROM_DATE_PARAM = "fromDate";
    private static final Object OAI_UNTIL_DATE_PARAM = "untilDate";
    private OaiIteratorFactory oaiIteratorFactory;

    @Override
    public Stream<String> collect(ApiDescriptor api) throws DnetCollectorException {
        String baseUrl = api.getBaseUrl();
        String mdFormat = (String)api.getParams().get(FORMAT_PARAM);
        String setParam = (String)api.getParams().get(OAI_SET_PARAM);
        String fromDate = (String)api.getParams().get(OAI_FROM_DATE_PARAM);
        String untilDate = (String)api.getParams().get(OAI_UNTIL_DATE_PARAM);
        ArrayList<String> sets = new ArrayList<String>();
        if (setParam != null) {
            sets.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)setParam)));
        }
        if (sets.isEmpty()) {
            sets.add("");
        }
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new DnetCollectorException("Param 'baseurl' is null or empty");
        }
        if (mdFormat == null || mdFormat.isEmpty()) {
            throw new DnetCollectorException("Param 'mdFormat' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new DnetCollectorException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        if (untilDate != null && !untilDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new DnetCollectorException("Invalid date (YYYY-MM-DD): " + untilDate);
        }
        Iterator iters = sets.stream().map(set -> this.getOaiIteratorFactory().newIterator(baseUrl, mdFormat, (String)set, fromDate, untilDate)).iterator();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Iterators.concat(iters), 16), false);
    }

    public OaiIteratorFactory getOaiIteratorFactory() {
        if (this.oaiIteratorFactory == null) {
            this.oaiIteratorFactory = new OaiIteratorFactory();
        }
        return this.oaiIteratorFactory;
    }
}

