/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation.functions;

import eu.dnetlib.dhp.transformation.vocabulary.Term;
import eu.dnetlib.dhp.transformation.vocabulary.Vocabulary;
import java.util.Map;
import java.util.Optional;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import scala.Serializable;

public class Cleaner
implements ExtensionFunction,
Serializable {
    private final Map<String, Vocabulary> vocabularies;

    public Cleaner(Map<String, Vocabulary> vocabularies) {
        this.vocabularies = vocabularies;
    }

    public QName getName() {
        return new QName("http://eu/dnetlib/trasform/extension", "clean");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE_OR_MORE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE), SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)};
    }

    public XdmValue call(XdmValue[] xdmValues) throws SaxonApiException {
        String currentValue = xdmValues[0].itemAt(0).getStringValue();
        String vocabularyName = xdmValues[1].itemAt(0).getStringValue();
        Optional<Term> cleanedValue = this.vocabularies.get(vocabularyName).getTerms().stream().filter(it -> it.getNativeName().equalsIgnoreCase(currentValue)).findAny();
        return new XdmAtomicValue(cleanedValue.isPresent() ? cleanedValue.get().getCode() : currentValue);
    }
}

